///
/// @file
/// @details This scene is the gameplay scene for the LudumDare35 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#include "title_scene.h"
#include "scene_manager.h"

#include "turtle_brains/graphics/unstable/tbu_gif_exporter.h"

//--------------------------------------------------------------------------------------------------------------------//

LudumDare35::TitleScene::TitleScene(void)
{
	tbGraphics::Sprite* backdrop(new tbGraphics::Sprite("data/title_screen.png"));
	//backdrop->SetColor(tbGraphics::Color(0x80FFFFFF));
	AddGraphic(backdrop);
}

//--------------------------------------------------------------------------------------------------------------------//

LudumDare35::TitleScene::~TitleScene(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::TitleScene::OnSimulate(void)
{
	tbGame::GameScene::OnSimulate();

}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::TitleScene::OnUpdate(const float deltaTime)
{
	tbGame::GameScene::OnUpdate(deltaTime);

	if (true == tbApplication::Input::IsKeyReleased(tbApplication::tbKeySpace))
	{
		theSceneManager->ChangeToScene(kGameplayScene);
	}

	if (true == tbApplication::Input::IsKeyReleased(tbApplication::tbKeyEscape))
	{	//This should be the very last check to happen as game ends immediately.
		theSceneManager->QuitGame();
	}

	tbGraphics::Unstable::GifPerformCapture(deltaTime, tbApplication::Input::IsKeyPressed(tbApplication::tbKeyG));
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::TitleScene::OnRender(void) const
{
	tbGame::GameScene::OnRender();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::TitleScene::OnOpen(void)
{
	tbGame::GameScene::OnOpen();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::TitleScene::OnClose(void)
{
	tbGame::GameScene::OnClose();
}

//--------------------------------------------------------------------------------------------------------------------//
