///
/// @file
/// @details This file contains implementation details specific to TurtleBrains and may be modified without warning.
/// @note using any classes, functions or definitions found within TurtleBrains::Implementation / tbImplementation is
///   not recommended as they can be changed or removed completely without warning.  This is your final warning.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrainsImplementation_RealtimeApplication_h_
#define _TurtleBrainsImplementation_RealtimeApplication_h_

#include "../../core/tb_string.h"
#include "../../core/tb_types.h"

namespace TurtleBrains
{
	namespace Application
	{
		class ApplicationHandlerInterface;
	};
};

namespace tbImplementation
{
	// The following system specific implementation details can be found in tbi_realtime_system_application.cpp.

	void OpenRealtimeApplication(TurtleBrains::Application::ApplicationHandlerInterface& applicationHandler);
	void RunRealtimeApplication(TurtleBrains::Application::ApplicationHandlerInterface& applicationHandler);
	void StopRealtimeApplication(TurtleBrains::Application::ApplicationHandlerInterface& applicationHandler);
	void CloseRealtimeApplication(TurtleBrains::Application::ApplicationHandlerInterface& applicationHandler);

	void SetWindowTitle(const tbCore::tbString& windowName);

};	/* namespace tbImplementation */

#endif /* _TurtleBrainsImplementation_RealtimeApplication_h_ */
