///
/// @file
/// @details This file contains implementation details specific to TurtleBrains and may be modified without warning.
/// @note using any classes, functions or definitions found within TurtleBrains::Implementation / tbImplementation is
///   not recommended as they can be changed or removed completely without warning.  This is your final warning.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrainsImplementation_ApplicationDialog_h_
#define _TurtleBrainsImplementation_ApplicationDialog_h_

#include "../../core/tb_types.h"
#include "../tb_application_dialog.h"

namespace TurtleBrains { namespace Application { class ApplicationHandlerInterface; } };

//The following system specific implementation details can be found in tb_system_application_dialog.cpp

namespace tbImplementation
{
	extern const size_t kMaximumAvailableDropdownItems;
	extern const size_t kMaximumDisplayedDropdownItems;

	///
	///	This may be an implementation detail, not yet sure.
	///
	enum DialogControlType
	{
		kLabelControl,
		kButtonControl,
		kCheckboxControl,
		kTextControl,
		kDropdownControl
	};

	///
	///
	///
	class DialogControl
	{
	public:
		tbApplication::DialogControlIdentifier mIdentifier;
		tbApplication::DialogControlGuide mGuide;
		DialogControlType mType;
		tbCore::tbString mValue;
		int mLeftEdgeOffset;	//A percentage based value.
		int mWidthPercentage;
		int mSlotInBucket;
		bool mIsVisible;
		bool mIsEnabled;
	};

	struct AreaRectangle
	{
		int mLeft;
		int mTop;
		int mWidth;
		int mHeight;
	};

	///
	///
	///
	void ResizeDialog(const tbApplication::DialogIdentifier& dialogIdentifier, const tbApplication::DialogBucketType& bucketType,
		const int numberVisibleSlots, const bool allowVerticalScrolling);

	///
	///
	///
	tbApplication::DialogBucketType GetDialogBucketType(const tbApplication::DialogIdentifier& dialogIdentifier);

	///
	///
	///
	int GetDialogNumberOfVisibleSlots(const tbApplication::DialogIdentifier& dialogIdentifier);

	///
	///
	///
	int GetDialogNumberOfFilledSlots(const tbApplication::DialogIdentifier& dialogIdentifier);

	///
	///
	///
	int GetDialogNumberOfFilledSlots(const tbApplication::DialogIdentifier& dialogIdentifier, const tbApplication::DialogControlGuide& forGuide);

	///
	///
	///
	bool IsControlSafeForDuplication(const tbApplication::DialogControlIdentifier& controlIdentifier);

	///
	///
	///
	void SetControlSafeForDuplication(const tbApplication::DialogControlIdentifier& controlIdentifier);

	///
	///
	///
	DialogControl* CreateDialogControl(const tbApplication::DialogIdentifier& dialogIdentifier, const tbApplication::DialogControlIdentifier& controlIdentifier,
		const DialogControlType& controlType, const tbCore::tbString& controlValue, const tbApplication::DialogControlGuide& guide);

	///
	///
	///
	void DestroyDialogControls(const tbApplication::DialogIdentifier& dialogIdentifier);

	///
	///
	///
	DialogControl* GetDialogControl(const tbApplication::DialogIdentifier& dialogIdentifier, const tbApplication::DialogControlIdentifier& controlIdentifier);

	///
	///
	///
	DialogControl* GetDialogControlByIndex(const tbApplication::DialogIdentifier& dialogIdentifier, const size_t& controlIndex);

	///
	///
	///
	size_t NumberOfControlsForDialog(const tbApplication::DialogIdentifier& dialogIdentifier);

	///
	///
	///
	void GetDialogArea(AreaRectangle& visibleRectangle, int& filledHeight, const tbApplication::DialogIdentifier& dialogIdentifier);

	///
	///
	///
	void GetDialogControlArea(AreaRectangle& rectangle, const DialogControl& dialogControl);

	///
	///
	///
	tbCore::tbString CheckboxToString(bool isChecked, const tbCore::tbString& name);

	///
	///
	///
	void StringToCheckbox(const tbCore::tbString& input, bool& isChecked, tbCore::tbString& name);

	///
	///
	///
	tbCore::tbString StringToCheckboxName(const tbCore::tbString& input);

	///
	///
	///
	tbCore::tbString DropdownToString(int selectedIndex, const std::vector<tbCore::tbString>& values);

	///
	///
	///
	void StringToDropdown(const tbCore::tbString& input, int& selectedIndex, std::vector<tbCore::tbString>& values);

	///
	///
	///
	void OpenDialog(const tbApplication::DialogIdentifier& dialogIdentifier, tbApplication::ApplicationHandlerInterface& applicationHandler);

	///
	///
	///
	void CloseDialog(const tbApplication::DialogIdentifier& dialogIdentifier, tbApplication::ApplicationHandlerInterface& applicationHandler);

};	/* namespace tbImplementation */

#endif /* _TurtleBrainsImplementation_ApplicationDialog_h_ */
