///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#include "tbi_system_application_input.h"

//-----------------------------------------------------------------------------------------------------------------//

namespace tbImplementation
{
	static bool tbiNeedsInitialization(true);
	static bool tbiCurrentKeyStates[tbApplication::tbKeyMax];
	static bool tbiPreviousKeyStates[tbApplication::tbKeyMax];

	static int tbiCurrentMouseX(0);
	static int tbiCurrentMouseY(0);
	static int tbiPreviousMouseX(0);
	static int tbiPreviousMouseY(0);

}; /* namespace tbImplementation */

//-----------------------------------------------------------------------------------------------------------------//

void tbImplementation::OnPressKey(const tbApplication::Key& key)
{
	tbiCurrentKeyStates[key] = true;
}

//-----------------------------------------------------------------------------------------------------------------//

void tbImplementation::OnReleaseKey(const tbApplication::Key& key)
{
	tbiCurrentKeyStates[key] = false;
}

//-----------------------------------------------------------------------------------------------------------------//

void tbImplementation::StartNewFrame(void)
{
	if (true == tbiNeedsInitialization)
	{
		tbiNeedsInitialization = false;
		for (size_t keyIndex = 0; keyIndex < tbApplication::tbKeyMax; ++keyIndex)
		{
			tbiCurrentKeyStates[keyIndex] = false;
		}
	}

	for (size_t keyIndex = 0; keyIndex < tbApplication::tbKeyMax; ++keyIndex)
	{
		tbiPreviousKeyStates[keyIndex] = tbiCurrentKeyStates[keyIndex];
	}

	tbiPreviousMouseX = tbiCurrentMouseX;
	tbiPreviousMouseY = tbiCurrentMouseY;
}

//-----------------------------------------------------------------------------------------------------------------//

void tbImplementation::UpdateMousePosition(int mouseX, int mouseY)
{
	tbiCurrentMouseX = mouseX;
	tbiCurrentMouseY = mouseY;
}

//-----------------------------------------------------------------------------------------------------------------//


//-----------------------------------------------------------------------------------------------------------------//
//-----------------------------------------------------------------------------------------------------------------//
//-----------------------------------------------------------------------------------------------------------------//

bool tbApplication::Input::IsKeyPressed(const tbApplication::Key& key)
{
	return (true == tbImplementation::tbiCurrentKeyStates[key] 
		&& false == tbImplementation::tbiPreviousKeyStates[key]) ? true : false;
}

//-----------------------------------------------------------------------------------------------------------------//

bool tbApplication::Input::IsKeyReleased(const tbApplication::Key& key)
{
	return (false == tbImplementation::tbiCurrentKeyStates[key] 
		&& true == tbImplementation::tbiPreviousKeyStates[key]) ? true : false;
}

//-----------------------------------------------------------------------------------------------------------------//

bool tbApplication::Input::IsKeyDown(const tbApplication::Key& key)
{
	return tbImplementation::tbiCurrentKeyStates[key];
}

//-----------------------------------------------------------------------------------------------------------------//

void tbApplication::Input::GetMousePosition(int* mouseX, int* mouseY)
{
	*mouseX = tbImplementation::tbiCurrentMouseX;
	*mouseY = tbImplementation::tbiCurrentMouseY;
}

//-----------------------------------------------------------------------------------------------------------------//

bool tbApplication::Input::GetMouseMovement(int* mouseX, int* mouseY)
{
	*mouseX = tbImplementation::tbiCurrentMouseX - tbImplementation::tbiPreviousMouseX;
	*mouseY = tbImplementation::tbiCurrentMouseY - tbImplementation::tbiPreviousMouseY;
	return (0 != *mouseX || 0 != *mouseY) ? true : false;
}

//-----------------------------------------------------------------------------------------------------------------//

void tbApplication::Input::SetMousePosition(int mouseX, int mouseY)
{
	tbImplementation::SetMousePosition(mouseX, mouseY);
}

//-----------------------------------------------------------------------------------------------------------------//
