///
/// @file
/// @details This file contains implementation details specific to TurtleBrains and may be modified without warning.
/// @note using any classes, functions or definitions found within TurtleBrains::Implementation / tbImplementation is
///   not recommended as they can be changed or removed completely without warning.  This is your final warning.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrainsImplementation_ApplicationMessageBox_h_
#define _TurtleBrainsImplementation_ApplicationMessageBox_h_

namespace TurtleBrains
{
	namespace Application
	{
		class ApplicationHandlerInterface;
		class ApplicationMenu;
	};	/* namespace Application */
};	/* namespace TurtleBrains */

#include "../../core/tb_types.h"

//The following system specific implementation details can be found in tb_system_application_message_box.cpp

namespace tbImplementation
{
	///
	///	@details This should be implemented to create a message prompt appear with a title, message and up to two
	///	buttons.  The return value should be true if the primary button was clicked, and false other wise.  It is
	/// expected that the user must click on either primaryButton or secondaryButton to close this message box.
	///
	bool ModalMessageBox(const tbCore::tbString& title, const tbCore::tbString& message, const tbCore::tbString& primaryButton, const tbCore::tbString& secondaryButton);

	///
	///
	///
	bool ModalOpenFileDialog(tbCore::tbString& fileToOpen, const tbCore::tbString& startDirectory, const tbCore::tbString& fileExtension);

	///
	///
	///
	bool ModalSaveFileDialog(tbCore::tbString& fileToSave, const tbCore::tbString& startDirectory, const tbCore::tbString& fileExtension);

};	/* namespace tbImplementation */

#endif /* _TurtleBrainsImplementation_ApplicationMessageBox_h_ */
