///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_ApplicationHandlerInterface_h_
#define _TurtleBrains_ApplicationHandlerInterface_h_

#include "tb_application_menu.h"
#include "tb_application_dialog.h"
#include "tb_application_window.h"

namespace TurtleBrains
{
	namespace Application
	{

		///
		/// @brief Handle events from the application/window and actions from the user of your application by deriving an
		///   an object from ApplicationHandlerInterface.
		///
		/// @details The RealtimeApplication takes an ApplicationHandlerInterface object that will handle window events and
		///   changes including actions the user of your application takes with menus and dialogs.  This is similar to the
		///   AppDelegate object in Cocoa or WndProc function in Win32.
		///
		class ApplicationHandlerInterface
		{
		public:
			///
			/// @details Destroys the ApplicationHandlerInterface object and cleans up any resources created or used during
			///   the lifetime of the object.
			///
			virtual ~ApplicationHandlerInterface(void) = 0;

			///
			/// @details Invoked only once while the window is being created, just before it is shown so that a window menu,
			///   status bar, or other portions can be setup and added to the window.
			///
			virtual void OnWindowOpen(void);

			///
			/// @details Invoked only once just before the window is destroyed, there is no way to cancel the window from
			///   closing once this is called.
			///
			virtual void OnWindowClose(void);

			///
			/// @details Invoked each time the window gains or regains focus.
			///
			virtual void OnBecomeActive(void);

			///
			/// @details Invoked each time the window loses focus to another application.
			///
			virtual void OnBecomeInactive(void);

			///
			/// @details Invoked once for each frame of a real-time application.  This is invoked very often and generally
			///   as quickly as possible.
			///
			virtual void OnRealtimeUpdate(void);

			///
			/// @details Invoked each time the user clicks a menu item from a Window Menu or Contect menu.
			///
			/// @param menu        The identifier of the menu object that was interacted with to be distinguished between
			///   one menu and the next within your application.
			/// @param menuItem    The menu item that was clicked by the user for the given menu.
			///
			virtual void OnMenuAction(const MenuIdentifier& menu, const MenuItemIdentifier& menuItem);

			///
			/// @details Invoked each time the user interacts with a dialog control of an active dialog object.  For more
			///   information about how this is invoked, see documentation on the ApplicationDialog functions that add a
			///   dialog control.
			///
			/// @see ApplicationDialog::AddButtonControl(), ApplicationDialog::AddCheckboxControl(),
			///   ApplicationDialog::AddDropdownControl(), ApplicationDialog::AddTextControl()
			///
			/// @param dialog           The identifier of the dialog object that was interacted with to be distinguished
			///   between one dialog and the next within your application.
			/// @param dialogControl    The dialog control that was interacted with, this action usually means the user
			///   clicked on the control (button, checkbox) but in some cases the action is reported when the user navigates
			///   to a different control (text) or selected a new option (dropdown).
			///
			virtual void OnDialogAction(const DialogIdentifier& dialog, const DialogControlIdentifier& dialogControl);

			///
			/// @details Invoked to retrieve the size, and properties of the Realtime OpenGL window during the creation of the
			///   window.
			///
			/// @param windowProperties A reference to the properties of the window, filled out by you.  The default settings
			///   are initialized beforehand, so if you want a default sized window, there is no need to do anything!
			///
			virtual void CollectWindowProperties(WindowProperties& windowProperties);
		private:
		};

	}; /* namespace Application */
}; /* namespace TurtleBrains */

namespace tbApplication = TurtleBrains::Application;

#endif /* _TurtleBrains_ApplicationHandlerInterface_h_ */
