///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_ApplicationWindow_h_
#define _TurtleBrains_ApplicationWindow_h_

#include "../core/tb_types.h"

namespace TurtleBrains
{
	namespace Application
	{

		///
		/// @details Holds information about the size and position of a window along with the context information for OpenGL.
		///
		struct WindowProperties
		{
			tbCore::int16 mWindowWidth;  ///< The width of the window rectangle in pixels.  The actual width may be larger to account for the window border.
			tbCore::int16 mWindowHeight; ///< The height of the window rectangle in pixels.  The actual height may be larger to account for the window title and border.
			tbCore::int16 mWindowPositionX; ///< The position of the left edge of the window in pixels.
			tbCore::int16 mWindowPositionY; ///< The position of the top edge of the window in pixels.
			bool mVerticalSync; ///< True if the rendering should be synchronized with the monitors refresh rate.

			///
			/// @details Sets the default width/height and location for the window. Likely to be (1280x720 at 100,100)
			///
			WindowProperties(void);
		};

	}; /* namespace Application */
}; /* namespace TurtleBrains */

namespace tbApplication = TurtleBrains::Application;

#endif /* _TurtleBrains_ApplicationWindow_h_ */
