///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

//System specific implementation details can be found in tbi_realtime_system_application.cpp

#include "tb_realtime_application.h"
#include "implementation/tbi_realtime_system_application.h"
#include "implementation/tbi_system_application_message_box.h"
#include "implementation/tbi_system_application_menu.h"
#include "implementation/tbi_system_application_status.h"
#include "implementation/tbi_system_application_dialog.h"
#include "tb_application_menu.h"

#include "../core/tb_error.h"
#include "../core/implementation/tbi_diagnostics.h"

#include <map>

extern const bool tbApplication::kResultOkay(true);
extern const bool tbApplication::kResultCancel(false);

//--------------------------------------------------------------------------------------------------------------------//

tbApplication::RealtimeApplication::RealtimeApplication(tbApplication::ApplicationHandlerInterface& applicationHandler) :
	mApplicationHandler(applicationHandler)
{
	//tbi_log_open();

//	tbImplementation::AddImplementationFor(this, applicationHandler);
}

//--------------------------------------------------------------------------------------------------------------------//

tbApplication::RealtimeApplication::~RealtimeApplication(void)
{
//	tbImplementation::RemoveImplementationFor(this);

	tbi_log_close();
}

//--------------------------------------------------------------------------------------------------------------------//

void tbApplication::RealtimeApplication::Open(void)
{
	tbImplementation::OpenRealtimeApplication(mApplicationHandler);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbApplication::RealtimeApplication::Run(void)
{
	tbImplementation::RunRealtimeApplication(mApplicationHandler);
}

//--------------------------------------------------------------------------------------------------------------------//

//void tbApplication::RealtimeApplication::Stop(void)
//{
//	tbImplementation::StopRealtimeApplication(mApplicationHandler);
//}

//--------------------------------------------------------------------------------------------------------------------//

void tbApplication::RealtimeApplication::Close(void)
{
	tbImplementation::CloseRealtimeApplication(mApplicationHandler);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbApplication::RealtimeApplication::SetWindowMenu(const ApplicationMenu& menu)
{
	tbImplementation::SetWindowMenu(menu, mApplicationHandler);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbApplication::RealtimeApplication::SetContextMenu(const ApplicationMenu& menu)
{
	tbImplementation::SetContextMenu(menu, mApplicationHandler);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbApplication::RealtimeApplication::SetWindowStatus(const ApplicationStatus& status)
{
	//TODO: TIM: This will need to use the non "assuming" version...
	tbImplementation::SetWindowStatus(status, mApplicationHandler);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbApplication::RealtimeApplication::SetWindowTitle(const tbCore::tbString& windowTitle)
{
	tbImplementation::SetWindowTitle(windowTitle);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbApplication::RealtimeApplication::OpenDialog(const ApplicationDialog& dialog)
{
	tbImplementation::OpenDialog(dialog.GetIdentifier(), mApplicationHandler);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbApplication::RealtimeApplication::CloseDialog(const ApplicationDialog& dialog)
{
	tbImplementation::CloseDialog(dialog.GetIdentifier(), mApplicationHandler);
}

//--------------------------------------------------------------------------------------------------------------------//
bool tbApplication::RealtimeApplication::OkayMessageBox(const tbCore::tbString& title, const tbCore::tbString& message)
{
	return tbImplementation::ModalMessageBox(title, message, tbCore::ToString("Okay"), tbCore::ToString(""));
}

//--------------------------------------------------------------------------------------------------------------------//

bool tbApplication::RealtimeApplication::OkayCancelMessageBox(const tbCore::tbString& title, const tbCore::tbString& message)
{
	return tbImplementation::ModalMessageBox(title, message, tbCore::ToString("Okay"), tbCore::ToString("Cancel"));
}

//--------------------------------------------------------------------------------------------------------------------//

bool tbApplication::RealtimeApplication::OpenFileDialog(tbCore::tbString& fileToOpen, const tbCore::tbString& fileExtension)
{
	return tbImplementation::ModalOpenFileDialog(fileToOpen, fileToOpen, fileExtension);
}

//--------------------------------------------------------------------------------------------------------------------//

bool tbApplication::RealtimeApplication::SaveFileDialog(tbCore::tbString& fileToSave, const tbCore::tbString& fileExtension)
{
	return tbImplementation::ModalSaveFileDialog(fileToSave, fileToSave, fileExtension);
}

//--------------------------------------------------------------------------------------------------------------------//

//tbImplementation::ApplicationInterface& tbImplementation::AddImplementationFor(tbApplication::RealtimeApplication* realtimeApplication, tbApplication::ApplicationHandlerInterface& applicationHandler)
//{
//	ImplementationContainer::iterator itr = mImplementations.find(realtimeApplication);
//	tb_error_if(mImplementations.end() != itr, "tbInternalError: Expected realtimeApplication not to exist yet, was already added to implementations.");
//
//	tbImplementation::ApplicationInterface* implementation = &tbImplementation::ApplicationInterface::CreateApplication(applicationHandler);
//	mImplementations.insert(ImplementationContainer::value_type(realtimeApplication, implementation));
//	return *implementation;
//}
//
////--------------------------------------------------------------------------------------------------------------------//
//
//tbImplementation::ApplicationInterface& tbImplementation::GetImplementationFor(tbApplication::RealtimeApplication* realtimeApplication)
//{
//	ImplementationContainer::iterator itr = mImplementations.find(realtimeApplication);
//	tb_error_if(mImplementations.end() == itr, "tbInternalError: Expected realtimeApplication to exist, was not yet added to implementations.");
//	return *itr->second;
//}
//
////--------------------------------------------------------------------------------------------------------------------//
//
//void tbImplementation::RemoveImplementationFor(tbApplication::RealtimeApplication* realtimeApplication)
//{
//	ImplementationContainer::iterator itr = mImplementations.find(realtimeApplication);
//	tb_error_if(mImplementations.end() == itr, "tbInternalError: Expected realtimeApplication to exist, was not yet added to implementations.");
//
//	tbImplementation::ApplicationInterface::DestroyApplication(*itr->second);
//	mImplementations.erase(itr);
//}
//
////--------------------------------------------------------------------------------------------------------------------//
