///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrainsImplementation_AudioData_h_
#define _TurtleBrainsImplementation_AudioData_h_

#include "../../core/tb_noncopyable.h"
#include "../../core/tb_string.h"
#include "../../core/tb_types.h"

#include <fstream>
#include <stdint.h>

namespace tbImplementation
{

	class AudioData : public tbCore::Noncopyable
	{
	public:

		AudioData(const tbCore::tbString& filename = tb_string(""));

		///
		/// @details Creates a buffer from a file in WAV format in memory.
		///
		AudioData(const unsigned char* fileDataInMemory, const size_t& fileSizeInBytes);
		~AudioData(void);

		void GetAudioData(tbCore::uint8* audioData, size_t& size) const;
		size_t GetAudioDataSize(void) const;
		tbCore::uint32 GetFormat(void) const;
		tbCore::uint32 GetFrequency(void) const;
		const tbCore::tbString& GetFileName(void) const;

	private:
		bool InitializeData(void);
		bool InitializeOggData(void);

		const tbCore::tbString mFileName;

		tbCore::uint8* mAudioData;
		mutable std::istream* mAudioFile;

//		unsigned int mSampleRate : 24;
//		unsigned int mBitsPerSample : 5; //Allows values 0 to 31.
//		unsigned int mChannels : 3;      //Allows values 0 to 7.
		tbCore::uint32 mSampleRate;
		tbCore::uint32 mBitsPerSample;
		tbCore::uint32 mChannels;
		size_t mAudioDataSize;
	};

}; /* namespace tbImplementation */


#endif /* _TurtleBrainsImplementation_AudioData_h_ */
