///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#include "tbi_audio_event_table.h"
#include "../../math/tb_random_numbers.h"

//--------------------------------------------------------------------------------------------------------------------//

tbImplementation::AudioEventTable::AudioEventTable(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

tbImplementation::AudioEventTable::~AudioEventTable(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void tbImplementation::AudioEventTable::AddAudioEvent(const tbCore::tbString& eventName, const tbAudio::AudioHandle& audioHandle,
	const bool isLooping)
{
	AudioEvent audioEvent;
	audioEvent.mAudioHandle = audioHandle;
	audioEvent.mIsLooping = isLooping;
	audioEvent.mVolumeControls[0] = 1.0f;
	audioEvent.mVolumeControls[1] = 1.0f;
	audioEvent.mVolumeControls[2] = 1.0f;
	audioEvent.mPitchControls[0] = 1.0f;
	audioEvent.mPitchControls[1] = 1.0f;
	audioEvent.mPitchControls[2] = 1.0f;

	mEventTable[eventName].push_back(audioEvent);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbImplementation::AudioEventTable::SetAudioEventPitch(const tbCore::tbString& eventName, float defaultPitch,
	float minimumPitch, float maximumPitch)
{
	EventTable::iterator eventIterator(mEventTable.find(eventName));
	tb_error_if(eventIterator == mEventTable.end(), "tbExternalError: AudioEvent with name \"%s\" does not exist in table.", eventName.c_str());
	AudioEvent& audioEvent(eventIterator->second.back());
	audioEvent.mPitchControls[0] = defaultPitch;
	audioEvent.mPitchControls[1] = (minimumPitch < 0.0f) ? defaultPitch : minimumPitch;
	audioEvent.mPitchControls[2] = (maximumPitch < 0.0f) ? defaultPitch : maximumPitch;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbImplementation::AudioEventTable::SetAudioEventVolume(const tbCore::tbString& eventName, float defaultVolume,
	float minimumVolume, float maximumVolume)
{
	EventTable::iterator eventIterator(mEventTable.find(eventName));
	tb_error_if(eventIterator == mEventTable.end(), "tbExternalError: AudioEvent with name \"%s\" does not exist in table.", eventName.c_str());
	AudioEvent& audioEvent(eventIterator->second.back());
	audioEvent.mVolumeControls[0] = defaultVolume;
	audioEvent.mVolumeControls[1] = (minimumVolume < 0.0f) ? defaultVolume : minimumVolume;
	audioEvent.mVolumeControls[2] = (maximumVolume < 0.0f) ? defaultVolume : maximumVolume;
}

//--------------------------------------------------------------------------------------------------------------------//

const tbImplementation::AudioEvent& tbImplementation::AudioEventTable::GetAudioEvent(const tbCore::tbString& eventName) const
{
	EventTable::const_iterator eventIterator(mEventTable.find(eventName));
	tb_error_if(eventIterator == mEventTable.end(), "tbExternalError: AudioEvent with name \"%s\" does not exist in table.", eventName.c_str());
	const EventContainer& events(eventIterator->second);
	tb_error_if(0 == events.size(), "tbInternalError: AudioEvent with name \"%s\" does not contain any audio handles.", eventName.c_str());
//	isLooping = events[0].mIsLooping;
//	return (1 == events.size()) ? events[0].mAudioHandle : events[tbMath::RandomInt() % events.size()].mAudioHandle;

	return (1 == events.size()) ? events[0] : events[tbMath::RandomInt() % events.size()];
}

//--------------------------------------------------------------------------------------------------------------------//

//--------------------------------------------------------------------------------------------------------------------//
