///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrainsImplementation_AudioEventTable_h_
#define _TurtleBrainsImplementation_AudioEventTable_h_

#include "../../core/tb_noncopyable.h"
#include "../../core/tb_string.h"
#include "../tb_audio_manager.h"

#include <map>
#include <vector>

namespace tbImplementation
{

	struct AudioEvent
	{
		tbAudio::AudioHandle mAudioHandle;
		bool mIsLooping;
		float mVolumeControls[3]; //default, minimum, maximum.
		float mPitchControls[3];  //default, minimum, maximum.
	};

	class AudioEventTable : public tbCore::Noncopyable
	{
	public:
		AudioEventTable(void);
		~AudioEventTable(void);

		void AddAudioEvent(const tbCore::tbString& eventName, const tbAudio::AudioHandle& audioHandle, const bool isLooping);
		void SetAudioEventPitch(const tbCore::tbString& eventName, float defaultPitch, float minimumPitch = -1.0f, float maximumPitch = -1.0f);
		void SetAudioEventVolume(const tbCore::tbString& eventName, float defaultVolume, float minimumVolume = -1.0f, float maximumVolume = -1.0f);

		const AudioEvent& GetAudioEvent(const tbCore::tbString& eventName) const;

	private:
		typedef std::vector<AudioEvent> EventContainer;
		typedef std::map<tbCore::tbString, EventContainer> EventTable;
		EventTable mEventTable;
	};

}; /* namespace tbImplementation */


#endif /* _TurtleBrainsImplementation_AudioEventTable_h_ */
