///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_Configuration_h_
#define _TurtleBrains_Configuration_h_

//TODO: TIM: Remove the settings in the build script and set them up here, hopefully automatically.
///Which system are we building for: (currently setup by build script).
//#define tb_windows
//#define tb_macosx
//#define tb_linux

#if !defined(tb_windows) && !defined(tb_macosx) && !defined(tb_linux)
  #error Unsupported or unknown platform configuration, make sure either: tb_windows, tb_macosx, or tb_linux is defined.
#endif /* tb_platform */

#if !defined(tb_release_build) && !defined(tb_debug_build)
	#if !defined(DEBUG) && !defined(_DEBUG)
		#define tb_release_build
	#else
		#define tb_debug_build
	#endif
#endif /* tb_debug or tb_release */

//Defines for the compiler being used, mainly to use specific 'features' of a compiler or avoid issues when building.
#if !defined(tb_visual_cpp) && !defined(tb_mingw)
  #if defined(_MSC_VER)
    #define tb_visual_cpp
  #elif defined(__MINGW32__)
    #define tb_mingw
  #endif
#endif /* compiler checks */

///Are we building for wide strings
//#define tb_wide_string

///These can be defined to explicitly enable/disable the debug logging systems.  By default the debug set is enabled
///in a build with tb_debug_build defined and disabled otherwise, although these switches will take precedence.

//#define tb_enable_debug_set   //Can force the debug_set to be enabled in a release build.
//#define tb_disable_debug_set  //Will disable debug_set regardless of enable define and debug/release build.

#define tb_enable_debug_set   //Can force the debug_set to be enabled in a release build.
#define tb_enable_diagnostics

///The following settings can change what TurtleBrains logs internally to the log created by the debug set.  The log will
///only be created if the debug set is enabled.  Further more the level of diagnostic information can be tweaked as well
///with the defines: tb_diagnose_errors, tb_diagnose_warnings, tb_diagnose_information and tb_diagnose_debugging which
///are all boolean, true for on, false for off.
#if !defined(tb_enable_diagnostics) && !defined(tb_disable_diagnostics)
  #define tb_enable_diagnostics
#endif

///Do you want to disable the TurtleBrains splash screen at startup?
#if !defined(tb_enable_splash) && !defined(tb_disable_splash)
  #define tb_enable_splash
#elif defined(tb_disable_splash)
	#undef tb_enable_splash
#endif


///Do you want to have less Math operators?  [TurtleBrains has not been built with this for sometime, but I am
///attempting to keep it supported.  This will disable several operator overloads and functions from the Vector and 
///Matrix objects to favor the use of the the functions that require objects to be passed in.  Useful for reducing 
///implicit/temporary objects from being created/passed, but does present more coding overhead/work.
//#define tb_math_less_operators

#endif /* _TurtleBrains_Configuration_h_ */
