///
/// @file
/// @details Setup preprocessor macros based on user settings, Release/Debug build etc so that when the macro version
///   of the functions are used (tb_dts_project_entry_point) vs (TurtleBrains::DebugToolSet::ProjectEntryPointF) they
///   may get dismissed at compile time if tb_debug_tool_set_disable is defined or a release build without the define
///   tb_debug_tool_set_enable.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#include "tb_debug_tool_set.h"

#if defined(tb_windows)
  #include <windows.h>
  #include "implementation/tbi_debug_exception_handler.h"
#endif /* tb_windows */

//--------------------------------------------------------------------------------------------------------------------//

void TurtleBrains::Debug::ProjectEntryPoint(void (*entryPoint)(void))
{
#if defined(tb_visual_cpp)
	__try
	{
		entryPoint();
	}
	__except (false == IsDebuggerPresent() && tbImplementation::HandleException(GetExceptionInformation()))
	{
		_exit(10); //all is lost
	}
#else
	try
	{
		entryPoint();
	}
	catch (...)
	{
	}
#endif
}

//--------------------------------------------------------------------------------------------------------------------//

int TurtleBrains::Debug::ProjectEntryPoint(int (*entryPoint)(const int argumentCount, const char* argumentValues[]), 
			const int argumentCount, const char* argumentValues[])
{
	int returnValue(0);

#if defined(tb_visual_cpp)
	__try
	{
		returnValue = entryPoint(argumentCount, argumentValues);
	}
	__except (false == IsDebuggerPresent() && tbImplementation::HandleException(GetExceptionInformation()))
	{
		_exit(10); //all is lost
	}
#else
	try
	{
		returnValue = entryPoint(argumentCount, argumentValues);
	}
	catch (...)
	{
	}
#endif

	return returnValue;
}

//--------------------------------------------------------------------------------------------------------------------//
