
#ifdef tb_generate_documentation
#error This file should not be included in any project. It is for generating TurtleBrains documentation using Doxygen.

//-------------------------------------------------------------------------------------------------------------------//
/// [exampleErrorIf]

#include "turtle_brains/core/tb_error.h"

int main(int argumentCount, char* argumentValues[])
{
	//The error will be triggered if the test is true.  tb_error_if(test == true, "Information about error.");
	tb_error_if(std::string("Hello World") != "Hello World", "Expected the Hello World strings to match!");
	return 0;
}

/// [exampleErrorIf]
//-------------------------------------------------------------------------------------------------------------------//
/// [exampleErrorHandler]

#include "turtle_brains/core/tb_error.h"
#include <iostream>

class MyErrorHandler : public tbCore::Error::ErrorHandlerInterface
{
	virtual void OnErrorFired(const std::string& errorMessage)
	{
		std::cout << "MyErrorHandler: Error in: " << GetFileName() << " on line: " << GetLineNumber() << std::endl;
		std::cout << "\tWith message: " << assertMessage << std::endl;
	}
};

static MyErrorHandler gsErrorHandler;

void main(int argumentCount, char* argumentValues[])
{
	tbCore::Error::AddErrorHandler(&gsErrorHandler);
	//The error will be triggered if the test is true.  tb_error_if(test == true, "Information about error.");
	tb_error_if(1 == 0, "This really should not trigger an error.");
	tb_error_if(1 == 1, "This really should trigger an error.");
	return 0;
}

/// [exampleErrorHandler]
//-------------------------------------------------------------------------------------------------------------------//
/// [exampleErrorExceptions]

#include "turtle_brains/core/tb_error.h"
#include <iostream>

void main(int argumentCount, char* argumentValues[])
{
	tbCore::Error::EnableThrowOnError();

	try
	{
		//The error will be triggered if the test is true.  tb_error_if(test == true, "Information about error.");
		tb_error_if(1 == 0, "This really should not throw an exception.");
		tb_error_if(1 == 1, "This really should throw an exception.");
	}
	catch (const std::exception& except)
	{
		std::cout << "Caught exception: " << except.what() << std::endl;
	}
	return 0;
}

/// [exampleErrorExceptions]
//-------------------------------------------------------------------------------------------------------------------//

#endif /* tb_generate_documentation */
