///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#include "tb_game_scene.h"
#include "../core/tb_noncopyable.h"
#include "../audio/tb_audio_manager.h"
#include "../game/tb_game_timer.h"
#include "../graphics/tb_sprite.h"
#include "../graphics/tb_texture_manager.h"
#include "../graphics/implementation/tbi_turtle_brains_logo.h"

namespace tbImplementation
{
	extern tbAudio::AudioHandle tbiTurtleBrainsJingleAudio; //Defined in tb_audio_manager.cpp

	class DefaultScene : public tbGame::GameScene
	{
	public:
		DefaultScene(void);
		virtual ~DefaultScene(void);

		virtual void OnSimulate(void) override;
		virtual void OnUpdate(const float deltaTime) override;
		virtual void OnOpen(void) override;

		friend void SetDefaultSceneToNextScene(tbGame::GameScene* nextScene);

	private:
		tbGame::GameScene* mNextScene;
		int mSceneTimer;
		int mJingleTimer;
	};

    void SetDefaultSceneToNextScene(tbGame::GameScene* nextScene);

	//Just a thought, may be implemented completely differently.
//	class TransitionScene : public tbGame::GameScene, public tbCore::Noncopyable
//	{
//	public:
//		TransitionScene(tbGame::GameScene& currentScene, tbGame::GameScene& nextScene);
//	};

	DefaultScene tbiDefaultScene;
	tbGame::GameScene* theDefaultScene(&tbiDefaultScene);

};	/* namespace tbImplementation */

//--------------------------------------------------------------------------------------------------------------------//

void tbImplementation::SetDefaultSceneToNextScene(tbGame::GameScene* nextScene)
{
	tbiDefaultScene.mNextScene = nextScene;
	tbiDefaultScene.mSceneTimer = 2500;
	tbiDefaultScene.mJingleTimer = 250;
}

//--------------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------------//

tbImplementation::DefaultScene::DefaultScene(void) :
	mNextScene(nullptr),
	mSceneTimer(0)
{
}

//--------------------------------------------------------------------------------------------------------------------//

tbImplementation::DefaultScene::~DefaultScene(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void tbImplementation::DefaultScene::OnSimulate(void)
{
	if (nullptr != mNextScene && mSceneTimer > 0)
	{
		mSceneTimer -= tbGame::GameTimer::GetMillisecondsPerStep();
		if (mSceneTimer <= 0)
		{
			ChangeToScene(*mNextScene);
			mNextScene = nullptr;
			mSceneTimer = 0;
		}
	}

	if (mJingleTimer > 0)
	{
		mJingleTimer -= 10;
		if (mJingleTimer <= 0)
		{
			tbAudio::theAudioManager.PlaySound(tbImplementation::tbiTurtleBrainsJingleAudio);
		}
	}
}

//--------------------------------------------------------------------------------------------------------------------//

void tbImplementation::DefaultScene::OnUpdate(const float deltaTime)
{
	tbGraphics::TextureHandle logoTexture = tbGraphics::theTextureManager.CreateTextureFromFileData(theTurtleBrainsLogoSourceData, theTurtleBrainsLogoSourceSize);
	tbGraphics::SpriteFrame logoFrame = { 0.0f, 0.0f, 256.0f, 256.0f, 0.0f, 0.0f, 1.0f, 1.0f, logoTexture };

	const float kWindowWidth(1280.0f);
	const float kWindowHeight(720.0f);

	tbGraphics::Sprite* logoSprite = new tbGraphics::Sprite(logoFrame);
	logoSprite->SetOrigin(tbGraphics::kAnchorCenter);
	logoSprite->SetPosition(kWindowWidth / 2.0f, kWindowHeight / 2.0f);
	AddGraphic(logoSprite);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbImplementation::DefaultScene::OnOpen(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//
