///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

#include "tb_entity_behavior_interface.h"
#include "tb_game_timer.h"
#include "tb_entity_manager.h"

//--------------------------------------------------------------------------------------------------------------------//

tbGame::EntityBehaviorInterface::EntityBehaviorInterface(Entity& entity) :
	mEntity(entity)
{
}

//--------------------------------------------------------------------------------------------------------------------//

tbGame::EntityBehaviorInterface::~EntityBehaviorInterface(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::EntityBehaviorInterface::OnAdded(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::EntityBehaviorInterface::OnRemoved(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::EntityBehaviorInterface::OnPaused(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::EntityBehaviorInterface::OnResume(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::EntityBehaviorInterface::OnSimulate(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::EntityBehaviorInterface::OnUpdate(const float deltaTime)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::EntityBehaviorInterface::OnRender(void) const
{
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::EntityBehaviorInterface::OnCollideWith(const Entity& other)
{
}

//--------------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------------//

void tbGame::DelayBehavior::OnSimulate(void)
{
	if (mDelayTimer.DecrementStep())
	{
		mEntity.PopBehavior();
	}
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::KillBehavior::OnSimulate(void)
{
	mEntity.GetEntityManager()->RemoveEntity(&mEntity);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::MoveBehavior::OnSimulate(void)
{
	const float deltaTime(tbGame::GameTimer::GetSecondsPerStep());
	mEntity.SetPosition(mEntity.GetPosition() + (mVelocity * deltaTime));
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::MoveToBehavior::OnSimulate(void)
{
	const float deltaTime(tbGame::GameTimer::GetSecondsPerStep());

	float maximumSpeed(mConstantMoveSpeed * deltaTime);
	tbMath::Vector2 movementDirection = mDesiredPosition - mEntity.GetPosition();

	if (movementDirection.Normalize() > maximumSpeed)
	{
		mEntity.SetPosition(mEntity.GetPosition() + (movementDirection * maximumSpeed));
	}
	else
	{
		mEntity.SetPosition(mDesiredPosition);
		mEntity.PopBehavior();
	}
}

//--------------------------------------------------------------------------------------------------------------------//