///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

#include "tb_game_application.h"
#include "../core/tb_error.h"
#include "../core/tb_opengl.h"
#include "../game/tb_game_scene.h"
#include "../system/tb_system_timer.h"
#include "../graphics/implementation/tbi_renderer.h"
#include "implementation/tbi_error_scene.h"

#include <vector>

namespace tbImplementation
{
	bool tbiMarkedForClosing(false);
	bool tbiIsGameActive(false);

	class GameApplicationHandler : public tbApplication::ApplicationHandlerInterface
	{
	public:
		GameApplicationHandler(void) :
			mGameApplication(nullptr)
		{
		}

		virtual ~GameApplicationHandler(void)
		{
		}

		virtual void OnWindowOpen(void) override
		{
			tb_error_if(nullptr == mGameApplication, "tbInternalError: Game Application has not been set before OnWindowOpen().");

			//glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
			//glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
			tb_check_recent_gl_errors("GameApplication::OnWindowOpen");

			tbSystem::Timer::Reset();
			mGameTimer.Reset();

			tbApplication::ApplicationHandlerInterface::OnWindowOpen();
			tbiIsGameActive = true; //This doesn't need to be called on Windows, but maybe on Mac/Linux? //TODO: TIM: Test and remove if possible.
		}

		virtual void OnRealtimeUpdate(void) override
		{
			tb_error_if(nullptr == mGameApplication, "tbInternalError: Game Application has not been set before OnRealtimeUpdate().");

			mGameTimer.Update();
			const float kMaxDeltaTimePerFrame(1.0f / 30.0f);
			const float realDeltaTime = static_cast<float>(mGameTimer.GetDeltaTime());
			const float deltaTime((realDeltaTime > kMaxDeltaTimePerFrame) ? kMaxDeltaTimePerFrame : realDeltaTime);

			tbGame::GameScene::PerformFrame(deltaTime);

			tbApplication::ApplicationHandlerInterface::OnRealtimeUpdate();

			if (true == tbiMarkedForClosing)
			{
				mGameApplication->Close();
			}
		}


		virtual void OnBecomeActive(void) override
		{
			tbiIsGameActive = true;
		}

		virtual void OnBecomeInactive(void) override
		{
			tbiIsGameActive = false;
		}

		virtual void OnMenuAction(const tbApplication::MenuIdentifier& menu, const tbApplication::MenuItemIdentifier& menuItem) override
		{
			if (nullptr != mApplicationHandler)
			{
				mApplicationHandler->OnMenuAction(menu, menuItem);
			}
		}

		virtual void OnDialogAction(const tbApplication::DialogIdentifier& dialog, const tbApplication::DialogControlIdentifier& dialogControl) override
		{
			if (nullptr != mApplicationHandler)
			{
				mApplicationHandler->OnDialogAction(dialog, dialogControl);
			}
		}

		virtual void CollectWindowProperties(tbApplication::WindowProperties& windowProperties) override
		{
			windowProperties = mWindowProperties;
		}

		tbGame::GameApplication* mGameApplication;
		tbApplication::ApplicationHandlerInterface* mApplicationHandler;
		tbSystem::Timer::Timer mGameTimer;
		tbApplication::WindowProperties mWindowProperties;
	};

	void SetDefaultSceneToNextScene(tbGame::GameScene* nextScene);	//Defined in tb_default_scene.cpp

	GameApplicationHandler tbiGameApplicationHandler;

};	/* namespace tbImplementation */


//--------------------------------------------------------------------------------------------------------------------//

tbGame::GameApplication::GameApplication(const tbGraphics::PixelSpace& windowWidth, const tbGraphics::PixelSpace& windowHeight, const bool verticalSync) :
	tbApplication::RealtimeApplication(tbImplementation::tbiGameApplicationHandler),
	mErrorScene(nullptr)
{
	tb_error_if(nullptr != tbImplementation::tbiGameApplicationHandler.mGameApplication, "tbInternalError: GameApplication has already been set.");
	tbImplementation::tbiGameApplicationHandler.mGameApplication = this;

	tbImplementation::tbiGameApplicationHandler.mWindowProperties.mWindowWidth = windowWidth;
	tbImplementation::tbiGameApplicationHandler.mWindowProperties.mWindowHeight = windowHeight;
	tbImplementation::tbiGameApplicationHandler.mWindowProperties.mVerticalSync = verticalSync;

	Open();

	//This actually needs to remain the very last handler to be triggered...
	tbCore::Error::AddErrorHandler(this);
}

//--------------------------------------------------------------------------------------------------------------------//

tbGame::GameApplication::~GameApplication(void)
{
	tbCore::Error::RemoveErrorHandler(this);
}

//--------------------------------------------------------------------------------------------------------------------//

//void tbGame::GameApplication::RunGame(const tbGame::GameStateIdentifier& stateIdentifier)
//{
//	tb_error_if(tbGame::kInvalidGameState == stateIdentifier, "tbExternalError: Expected stateIdentifier to be a valid game state.");
//	//tbImplementation::tbiInitialGameState = stateIdentifier;
////	Open();
//
//	tbGame::SetGameState(stateIdentifier);
//	Run();
//
//	std::vector<GameStateIdentifier>& stateIdentifiers = tbImplementation::tbiGameApplicationData.mStateIdentifiers;
//	while (false == stateIdentifiers.empty())
//	{
//		Game::RemoveGameState(stateIdentifiers.back());
//		stateIdentifiers.pop_back();
//	}
//}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::GameApplication::RunGame(GameScene& gameScene)
{
//	tb_error_if(nullptr == gameScene, "tbExternalError: Expected gameScene to be valid.");

#if !defined(tb_enable_splash) || defined(DEBUG) || defined(_DEBUG)
	GameScene::ChangeToScene(gameScene);
#else
	if (&gameScene != mErrorScene)
	{
		tbImplementation::SetDefaultSceneToNextScene(&gameScene);
	}
#endif /* tb_enable_splash */
	Run();
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::GameApplication::SetApplicationHandler(tbApplication::ApplicationHandlerInterface* applicationHandler)
{
	tbImplementation::tbiGameApplicationHandler.mApplicationHandler = applicationHandler;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::GameApplication::MarkForClose(void)
{
	tbImplementation::tbiMarkedForClosing = true;
}

//--------------------------------------------------------------------------------------------------------------------//

bool tbGame::GameApplication::IsGameActive(void)
{
	return tbImplementation::tbiIsGameActive;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::GameApplication::OnErrorFired(const std::string& errorMessage)
{
	tbCore::tbString errorLocation("\n\n" + GetFileName() + "  LINE: " + tbCore::ToString(GetLineNumber()));
	OkayMessageBox("Error Condition Triggered", errorMessage + errorLocation);
}

//--------------------------------------------------------------------------------------------------------------------//
