///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

#include "tb_game_scene.h"
#include "tb_entity.h"
#include "tb_game_timer.h"
#include "../core/tb_opengl.h"
#include "../core/tb_noncopyable.h"
#include "../graphics/tb_sprite.h"
#include "../graphics/tb_texture_manager.h"
#include "../graphics/tb_camera.h"
#include "../graphics/implementation/tbi_turtle_brains_logo.h"
#include "../graphics/implementation/tbi_renderer.h"
#include "../audio/tb_audio_manager.h"

namespace tbImplementation
{
	extern tbGame::GameScene* theDefaultScene; //Defined in tb_default_scene.cpp

	tbGame::GameScene* tbiNextScene(nullptr);
	tbGame::GameScene* tbiCurrentScene(nullptr);

};	/* namespace tbImplementation */

//--------------------------------------------------------------------------------------------------------------------//

tbGame::GameScene::GameScene(void) :
	mAccumulatedSimulationTime(0.0f)
{
}

//--------------------------------------------------------------------------------------------------------------------//

tbGame::GameScene::~GameScene(void)
{
	if (tbImplementation::tbiCurrentScene == this)
	{	//Calling OnClose() wouldn't be useful here, the derived class already destroyed.
		tbImplementation::tbiCurrentScene = nullptr;
	}
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::GameScene::OnSimulate(void)
{
	EntityManager::Simulate();
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::GameScene::OnUpdate(const float deltaTime)
{
	EntityManager::OnUpdate(deltaTime);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::GameScene::OnRender(void) const
{
	tbImplementation::Renderer::PushMatrix();
	
	const tbMath::Vector2& screenCenter(tbGraphics::ScreenCenter());
	tbImplementation::Renderer::Translate(screenCenter.x, screenCenter.y, 0.0f);
	tbImplementation::Renderer::Rotate(-tbGraphics::GetActiveCamera().GetRotation(), 0.0f, 0.0f, 1.0f);
	tbImplementation::Renderer::Translate(-screenCenter.x, -screenCenter.y, 0.0f);

	EntityManager::OnRender();

	tbImplementation::Renderer::PopMatrix();
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::GameScene::OnOpen(void)
{
	mAccumulatedSimulationTime = 0.0f;
	tbGraphics::SetActiveCamera(mCamera);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::GameScene::OnClose(void)
{
	tbGraphics::SetActiveCamera(nullptr);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::GameScene::ChangeToScene(TurtleBrains::Game::GameScene& gameScene)
{
	tbImplementation::tbiNextScene = &gameScene;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::GameScene::PerformFrame(const float deltaTime)
{
	if (nullptr != tbImplementation::tbiNextScene)
	{
		if (nullptr != tbImplementation::tbiCurrentScene)
		{
			tbImplementation::tbiCurrentScene->OnClose();
		}

		tbImplementation::tbiCurrentScene = tbImplementation::tbiNextScene;
		tbImplementation::tbiCurrentScene->OnOpen();
		tbImplementation::tbiNextScene = nullptr;
	}

	if (nullptr != tbImplementation::tbiCurrentScene)
	{
		PerformFrame(*tbImplementation::tbiCurrentScene, deltaTime);
	}
	else
	{
		PerformFrame(*tbImplementation::theDefaultScene, deltaTime);
	}
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::GameScene::PerformFrame(GameScene& gameScene, const float deltaTime)
{
	int numberOfSimulateCalls(0);
	const float kSecondsPerStep(tbGame::GameTimer::GetSecondsPerStep());
	gameScene.mAccumulatedSimulationTime += deltaTime;
	while (gameScene.mAccumulatedSimulationTime > kSecondsPerStep && numberOfSimulateCalls < 5)
	{
		gameScene.OnSimulate();
		++numberOfSimulateCalls;
		gameScene.mAccumulatedSimulationTime -= kSecondsPerStep;
	}

	tbAudio::theAudioManager.Update();
	gameScene.OnUpdate(deltaTime);
	tbGraphics::GetActiveCamera().Update(deltaTime);

	if (true == tbImplementation::Renderer::tbiIsRendererAvailable)
	{	
		{	//Often this is an uneccessary step and extra fill...  TODO: TIM: Reconsider.
			tb_check_gl_errors(glClearColor(0.0f, 0.0f, 0.0f, 0.0f));
			tb_check_gl_errors(glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT));
		}

		tbImplementation::Renderer::BeginDraw();
		gameScene.OnRender();
		tbImplementation::Renderer::EndDraw();
	}
}

//--------------------------------------------------------------------------------------------------------------------//
