///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_TileSystem_h_
#define _TurtleBrains_TileSystem_h_

#include "../core/tb_string.h"
#include "../core/tb_dynamic_structure.h"
#include "../graphics/tb_graphic_list.h"
#include "../graphics/tb_sprite_map.h"
#include "../math/tb_vector.h"

#include <vector>
#include <map>

namespace tbImplementation
{
	class TileSystemRenderer;
};

namespace TurtleBrains { namespace Game { namespace Unstable { class TileSystemCollider; }; }; };
namespace TurtleBrains { namespace Math { namespace Unstable { class BoundingVolume; }; }; };

namespace TurtleBrains
{
	namespace Game
	{

		///
		/// @details The TileIndex is a 16bit unsigned integer value indexing into a TileSet for a specific tile. This means
		///   each TileSet is limited to a maximum of 65535 different tiles, kinda like 256 columns by 256 rows, or 512 columns
		///   by 128 rows or any other combination. Seriously though, that is a lot of tiles on a single tileset. The maximum
		///   value is reserved for kInvalidTileIndex.
		///
		typedef tbCore::uint16 TileIndex;

		///
		/// @details A TileIndex value that represents no tile, an empty / invalid TileIndex.
		///
		extern const TileIndex kInvalidTileIndex;

		///
		/// @details TODO: TIM: Documentation: Teach the user how to use this.
		///
		typedef tbCore::uint16 TileLocation;

		extern const TileLocation kInvalidTileLocation; ///< TODO: TIM: Documentation: Teach the user how to use this.

		typedef tbCore::uint8 TileSetIndex; ///< TODO: TIM: Documentation: Teach the user how to use this.

		extern const TileSetIndex kInvalidTileSetIndex; ///< TODO: TIM: Documentation: Teach the user how to use this.

		///
		/// @details TODO: TIM: Documentation: Teach the user how to use this.
		///
		struct AboutTile
		{
			TileLocation mRow; ///< TODO: TIM: Documentation: Teach the user how to use this.
			TileLocation mColumn; ///< TODO: TIM: Documentation: Teach the user how to use this.
			TileIndex mTileIndex; ///< TODO: TIM: Documentation: Teach the user how to use this.

			float mCenterX; ///< TODO: TIM: Documentation: Teach the user how to use this.
			float mCenterY; ///< TODO: TIM: Documentation: Teach the user how to use this.
			float mTop; ///< TODO: TIM: Documentation: Teach the user how to use this.
			float mLeft; ///< TODO: TIM: Documentation: Teach the user how to use this.
			float mWidth; ///< TODO: TIM: Documentation: Teach the user how to use this.
			float mHeight; ///< TODO: TIM: Documentation: Teach the user how to use this.
			tbCore::DynamicStructure mPropertyValue; ///< TODO: TIM: Documentation: Teach the user how to use this.
		};

		typedef std::vector<AboutTile> AboutTileContainer; ///< TODO: TIM: Documentation: Teach the user how to use this.

		///
		///	@details The TileSystem contains details about all the different tiles used as well as stores multiple tile
		///   layers to be rendered.  Loads tile maps edited with Tiled when saved in the json format, although only basic
		///   support will be added in this first version.
		///
		/// The TileSystem has a lot of components working together, Tiles, TileSets and TileLayers it is important to
		///   understand the differences between each of these objects, particularly between TileSets and TileLayers. Each
		///   Tile
		///
		class TileSystem : public tbGraphics::Graphic, public tbCore::Noncopyable
		{
		public:

			///
			/// @details Constructs an empty TileSystem with no tilesets, no tiles and no layers.
			///
			TileSystem(void);

			///
			/// @details Destroys the TileSystem object which will clean up all resources for each of the layers and tilesets.
			///
			virtual ~TileSystem(void);

			///
			/// @details Clean up all resources for each of the layers and tilesets, will contain no tilesets, layers or tiles
			///   after this is complete.
			///
			void ClearMap(void);
			
			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			tbCore::tbString GetMapPropertyAsString(const tbCore::tbString& propertyName) const;

			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			int GetMapPropertyAsInteger(const tbCore::tbString& propertyName) const;

			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			bool GetMapPropertyAsBoolean(const tbCore::tbString& propertyName) const;

			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			void SetPropertiesForMap(const tbCore::DynamicStructure& mapProperties);

			///
			/// @details Adds a tileset with a given name to the TileSystem.
			///
			void AddTileSet(const tbCore::tbString& tilesetName, const tbGraphics::SpriteMap& spriteMap,
				const tbCore::DynamicStructure& tileSetProperties = tbCore::DynamicStructure::kNullValue);

			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
//			void SetFlagsForTile(const tbCore::tbString& tileSetName, const TileIndex& tileIndex, const TileFlags& tileFlags);

			///
			///
			///
			AboutTileContainer FindTilesWithProperty(const tbCore::tbString& tileProperty, bool onlyVisibleLayers = false) const;

			///
			///	@details TODO: TIM: Documentation: Teach the user how to use this.
			///
			AboutTileContainer FindTilesWithPropertyEquals(const tbCore::tbString& tileProperty, bool propertyValue, bool onlyVisibleLayers = false) const;

			///
			///	@details TODO: TIM: Documentation: Teach the user how to use this.
			///
			AboutTileContainer FindTilesWithPropertyEquals(const tbCore::tbString& tileProperty, int propertyValue, bool onlyVisibleLayers = false) const;

			///
			///	@details TODO: TIM: Documentation: Teach the user how to use this.
			///
			AboutTileContainer FindTilesWithPropertyEquals(const tbCore::tbString& tileProperty, const tbCore::tbString& propertyValue, bool onlyVisibleLayers = false) const;

			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			void SetPropertiesForTile(const tbCore::tbString& tileSetName, const TileIndex& tileIndex, const tbCore::DynamicStructure& tileProperties);

			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			tbCore::tbString GetTilePropertyAsString(const tbCore::tbString& tileSetName, const TileIndex& tileIndex, const tbCore::tbString& propertyName) const;

			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			int GetTilePropertyAsInteger(const tbCore::tbString& tileSetName, const TileIndex& tileIndex, const tbCore::tbString& propertyName) const;

			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			bool GetTilePropertyAsBoolean(const tbCore::tbString& tileSetName, const TileIndex& tileIndex, const tbCore::tbString& propertyName) const;

			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			void SetTileProperty(const tbCore::tbString& tileSetName, const TileIndex& tileIndex,
				const tbCore::tbString& propertyName, const tbCore::tbString& propertyValue);

			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			void SetTileProperty(const tbCore::tbString& tileSetName, const TileIndex& tileIndex,
				const tbCore::tbString& propertyName, const int propertyValue);

			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			void SetTileProperty(const tbCore::tbString& tileSetName, const TileIndex& tileIndex,
				const tbCore::tbString& propertyName, const bool propertyValue);

			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			void AddTileLayer(const tbCore::tbString& tileLayerName, const std::vector<TileIndex>& tileData,
				const tbCore::tbString& tileSetName, const TileLocation& columnCount, const TileLocation& rowCount);

			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			void AddTileLayer(const tbCore::tbString& tileLayerName, const std::vector<TileIndex>& tileData,
												const std::vector<TileSetIndex>& tileSetData, const TileLocation& columnCount, const TileLocation& rowCount);

			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			void SetLayerVisible(const tbCore::tbString& tileLayerName, const bool isVisible);


			///
			///
			///
			//
			//
			//
			//bool Move(const tbGame::Entity& entity, const tbMath::Vector2& from, tbMath::Vector2& to);
			//bool Move(const tbMath::Unstable::BoundingVolume& boundingVolume, const tbMath::Vector2& centerFrom, tbMath::Vector2& centerTo)

			///
			///	@details TODO: TIM: Documentation: Teach the user how to use this.
			///
			bool MoveEntity(const tbMath::Vector2& currentPosition, tbMath::Vector2& finalPosition,
				const TurtleBrains::Math::Unstable::BoundingVolume& boundingVolume) const;

			///
			///	@details TODO: TIM: Documentation: Teach the user how to use this.
			///
			bool IsPointInSolid(const tbMath::Vector2& pointPosition) const;

			///
			///	@details TODO: TIM: Documentation: Teach the user how to use this.
			///
			void UpdateColliderInformation(void);

///////////// Use the following at your own risk, the API is still fluid.
//			TileLocation PixelSpaceToColumn(const float locationX) const;
//			TileLocation PixelSpaceToRow(const float locationY) const;
//			float ColumnToPixelSpace(const TileLocation& column) const;
//			float RowToPixelSpace(const TileLocation& row) const;
/////////////

		protected:

			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			virtual void OnRender(void) const override;

		private:
			const tbCore::DynamicStructure& GetTileProperties(const tbCore::tbString& tileSetName, const TileIndex& tileIndex) const;
			tbCore::DynamicStructure& GetTileProperties(const tbCore::tbString& tileSetName, const TileIndex& tileIndex);

			struct TileLayer
			{
				tbMath::Vector2 mPosition;
				TileLocation mTileColumns;
				TileLocation mTileRows;
				typedef std::vector<TileIndex> TileContainer;
				TileContainer mTileData; //(TileIndex)-1 = no tile, 0 based on the TileSetData it lies upon.
				typedef std::vector<TileSetIndex> TileSetContainer;
				TileSetContainer mTileSetData; //Will be size 1 for a single Tileset, index into ordered names. Not yet implemented ...

				bool mIsVisible;
			};

			struct TileSet
			{
				TileSet(const tbGraphics::SpriteMap& spriteMap);

				tbGraphics::SpriteMap mSpriteMap;
				//TileIndex mStartTileID; //May be unneeded.
				//TileIndex mFinalTileID; //May be unneeded.

				//Stored as the index of the tile in this tile set, so 0 would be top-left most tile in SpriteMap.
//				typedef std::map<tbCore::uint16, std::pair<TileFlags, tbCore::DynamicStructure> > TilePropertyTable;
				typedef std::map<tbCore::uint16, tbCore::DynamicStructure> TilePropertyTable;
				TilePropertyTable mTileProperties;
				tbCore::DynamicStructure mTileSetProperties;
			};

			typedef std::vector<tbCore::tbString> NameContainer;
			typedef std::map<tbCore::tbString, TileLayer> TileLayerTable;
			TileLayerTable mTileLayers;
			NameContainer mOrderedLayerNames;
			NameContainer mOrderedTileSetNames;

			typedef std::map<tbCore::tbString, TileSet> TileSetTable;
			TileSetTable mTileSets;
			tbCore::DynamicStructure mMapProperties;

			/// TileSystem Rendering, this can change during OnRender() but does not effect the state of the TileSystem beyond
			/// optimizing the rendering process.
			typedef std::map<tbCore::tbString, tbImplementation::TileSystemRenderer*> LayerRendererTable;
			mutable LayerRendererTable mLayerRenderers;

			TurtleBrains::Game::Unstable::TileSystemCollider* mCollider;
		};

		namespace Extensions
		{
			///
			/// @details Clears the current state of the TileSystem with a call to ClearMap() then loads tilesets, layers and
			///   tile property/data from a json file saved with json.
			///
			bool LoadTileSystemFromTiled(TileSystem& tileSystem, const tbCore::tbString& tiledFilepath);
		};

	}; /* namespace Game */
}; /* namespace TurtleBrains */

namespace tbGame = TurtleBrains::Game;

#endif /* _TurtleBrains_TileSystem_h_ */
