///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#include "tb_camera.h"
#include "../math/tb_math.h"
#include "../math/tb_random_numbers.h"

namespace tbImplementation
{
	bool tbiIsCameraManaged(false);
	tbGraphics::Camera* tbiActiveCamera(nullptr);
	tbGraphics::Camera tbiDefaultCamera;
};

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::SetActiveCamera(tbGraphics::Camera& camera)
{
	if (true == tbImplementation::tbiIsCameraManaged && nullptr != tbImplementation::tbiActiveCamera)
	{
		delete tbImplementation::tbiActiveCamera;
		tbImplementation::tbiIsCameraManaged = false;
	}

	tbImplementation::tbiActiveCamera = &camera;
	tbImplementation::tbiIsCameraManaged = false;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::SetActiveCamera(tbGraphics::Camera* camera)
{
	if (true == tbImplementation::tbiIsCameraManaged && nullptr != tbImplementation::tbiActiveCamera)
	{
		delete tbImplementation::tbiActiveCamera;
		tbImplementation::tbiIsCameraManaged = false;
	}

	tbImplementation::tbiActiveCamera = camera;
	tbImplementation::tbiIsCameraManaged = true;
}

//--------------------------------------------------------------------------------------------------------------------//

tbGraphics::Camera& tbGraphics::GetActiveCamera(void)
{
	return (nullptr != tbImplementation::tbiActiveCamera) ? *tbImplementation::tbiActiveCamera : tbImplementation::tbiDefaultCamera;
}

//--------------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------------//

tbGraphics::Camera::Camera(void) :
	mPosition(tbMath::Vector2::kZero),
	mShakeOffset(tbMath::Vector2::kZero),
	mRotation(0.0f),
	mShakeIntensity(0.0f),
	mShakeDuration(-1.0f)
{
}

//--------------------------------------------------------------------------------------------------------------------//

tbGraphics::Camera::~Camera(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Camera::Update(const float deltaTime)
{
	if (mShakeDuration < 0.0f)
	{
		mShakeOffset = tbMath::Vector2::kZero;
	}
	else
	{
		mShakeDuration -= deltaTime;
		mShakeOffset = tbMath::Vector2(tbMath::RandomFloat(-mShakeIntensity, mShakeIntensity), tbMath::RandomFloat(-mShakeIntensity, mShakeIntensity));
	}
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Camera::ShakeCamera(const tbGraphics::Camera::IntensityLevel& shakeIntensity, const float shakeDuration)
{
	switch (shakeIntensity)
	{
	case kNoShaking: 
		mShakeIntensity = 0.0f;
		mShakeDuration = -1.0f;
		break;
	case kLightShaking:
		mShakeIntensity = 2.0f;
		mShakeDuration = (shakeDuration <= 0.0f) ? 0.2f : shakeDuration;
		break;
	case kMediumShaking: 
		mShakeIntensity = 4.0f;
		mShakeDuration = (shakeDuration <= 0.0f) ? 0.3f : shakeDuration;
		break;
	case kHeavyShaking:
		mShakeIntensity = 8.0f;
		mShakeDuration = (shakeDuration <= 0.0f) ? 0.4f : shakeDuration;
		break;
	default:
		tb_error("tbInternalError: Unhandled case fo IntensityLevel");
		break;
	};
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Camera::SetPosition(const tbMath::Vector2& cameraPosition)
{
	mPosition = cameraPosition;
}

//--------------------------------------------------------------------------------------------------------------------//

const tbMath::Vector2& tbGraphics::Camera::GetPosition(void) const
{
	return mPosition;
}

//--------------------------------------------------------------------------------------------------------------------//

tbMath::Vector2 tbGraphics::Camera::GetPositionWithShake(void) const
{
	return mPosition + mShakeOffset;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Camera::SetRotation(const float cameraRotation)
{
	mRotation = cameraRotation;
}

//--------------------------------------------------------------------------------------------------------------------//

float tbGraphics::Camera::GetRotation(void) const
{
	return mRotation;
}

//--------------------------------------------------------------------------------------------------------------------//
