///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#include "tb_color.h"
#include "../math/tb_math.h"

//--------------------------------------------------------------------------------------------------------------------//

const tbCore::uint32 kDefaultColor(0xFFFFFFFF);

const tbGraphics::Color tbGraphics::Color::kRed(0xFFFF0000);
const tbGraphics::Color tbGraphics::Color::kGreen(0xFF00FF00);
const tbGraphics::Color tbGraphics::Color::kBlue(0xFF0000FF);
const tbGraphics::Color tbGraphics::Color::kWhite(0xFFFFFFFF);
const tbGraphics::Color tbGraphics::Color::kBlack(0xFF000000);

//--------------------------------------------------------------------------------------------------------------------//

tbGraphics::Color::Color(void)
{
	SetColor(kDefaultColor);
}

//--------------------------------------------------------------------------------------------------------------------//

tbGraphics::Color::Color(const tbCore::uint32& colorARGB)
{
	SetColor(colorARGB);
}

//--------------------------------------------------------------------------------------------------------------------//

tbGraphics::Color::Color(const float clampedAlpha, const float clampedRed, const float clampedGreen, const float clampedBlue)
{
	SetColor(clampedAlpha, clampedRed, clampedGreen, clampedBlue);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Color::SetColor(const tbCore::uint32& colorARGB)
{
	mARGB = colorARGB;

	mAlpha = ((colorARGB >> 24) & 0xFF) / 255.0f;
	mRed = ((colorARGB >> 16) & 0xFF) / 255.0f;
	mGreen = ((colorARGB >> 8) & 0xFF) / 255.0f;
	mBlue = (colorARGB & 0xFF) / 255.0f;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Color::SetColor(const float clampedAlpha, const float clampedRed, const float clampedGreen, const float clampedBlue)
{
	mAlpha = tbMath::Clamp(clampedAlpha, 0.0f, 1.0f);
	mRed = tbMath::Clamp(clampedRed, 0.0f, 1.0f);
	mGreen = tbMath::Clamp(clampedGreen, 0.0f, 1.0f);
	mBlue = tbMath::Clamp(clampedBlue, 0.0f, 1.0f);

	mARGB = (((static_cast<tbCore::uint32>(mAlpha * 255.0f) & 0xFF) << 24) | ((static_cast<tbCore::uint32>(mRed * 255.0f) & 0xFF) << 16) |
						((static_cast<tbCore::uint32>(mGreen * 255.0f) & 0xFF) << 8) | (static_cast<tbCore::uint32>(mBlue * 255.0f) & 0xFF));
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Color::SetColor(const float clampedTween, const Color& startColor, const Color& finalColor)
{
	if (clampedTween < 0.0f) { SetColor(startColor.GetColorARGB()); }
	if (clampedTween > 1.0f) { SetColor(finalColor.GetColorARGB()); }

	const float alphaDifference(finalColor.GetAlpha() - startColor.GetAlpha());
	const float redDifference(finalColor.GetRed() - startColor.GetRed());
	const float greenDifference(finalColor.GetGreen() - startColor.GetGreen());
	const float blueDifference(finalColor.GetBlue() - startColor.GetBlue());

	SetColor(startColor.GetAlpha() + (alphaDifference * clampedTween),
					 startColor.GetRed() + (redDifference * clampedTween),
					 startColor.GetGreen() + (greenDifference * clampedTween),
					 startColor.GetBlue() + (blueDifference * clampedTween));
}

//--------------------------------------------------------------------------------------------------------------------//

tbCore::uint32 tbGraphics::Color::GetColorARGB(void) const
{
	return mARGB;
}

//--------------------------------------------------------------------------------------------------------------------//

tbCore::uint32 tbGraphics::Color::GetColorABGR(void) const
{
	return (((static_cast<tbCore::uint32>(mAlpha * 255.0f) & 0xFF) << 24) | ((static_cast<tbCore::uint32>(mBlue * 255.0f) & 0xFF) << 16) |
		((static_cast<tbCore::uint32>(mGreen * 255.0f) & 0xFF) << 8) | (static_cast<tbCore::uint32>(mRed * 255.0f) & 0xFF));
}

//--------------------------------------------------------------------------------------------------------------------//

tbCore::uint8 tbGraphics::Color::GetAlphaByte(void) const
{
	return ((mARGB >> 24) & 0xFF);
}

//--------------------------------------------------------------------------------------------------------------------//

tbCore::uint8 tbGraphics::Color::GetRedByte(void) const
{
	return ((mARGB >> 16) & 0xFF);
}

//--------------------------------------------------------------------------------------------------------------------//

tbCore::uint8 tbGraphics::Color::GetGreenByte(void) const
{
	return ((mARGB >> 8) & 0xFF);
}

//--------------------------------------------------------------------------------------------------------------------//

tbCore::uint8 tbGraphics::Color::GetBlueByte(void) const
{
	return (mARGB & 0xFF);
}

//--------------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------------//

float tbGraphics::Color::GetAlpha(void) const
{
	return mAlpha;
}

//--------------------------------------------------------------------------------------------------------------------//

float tbGraphics::Color::GetRed(void) const
{
	return mRed;
}

//--------------------------------------------------------------------------------------------------------------------//

float tbGraphics::Color::GetGreen(void) const
{
	return mGreen;
}

//--------------------------------------------------------------------------------------------------------------------//

float tbGraphics::Color::GetBlue(void) const
{
	return mBlue;
}

//--------------------------------------------------------------------------------------------------------------------//
