///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#include "tb_graphic_list.h"
#include "implementation/tbi_renderer.h"
#include "../core/tb_opengl.h"

#include <algorithm>

//--------------------------------------------------------------------------------------------------------------------//

tbGraphics::GraphicList::GraphicList(void)
{
	SetScroll(0.0f);
}

//--------------------------------------------------------------------------------------------------------------------//

tbGraphics::GraphicList::~GraphicList(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::GraphicList::OnUpdate(const float deltaTime)
{
	for (GraphicContainer::iterator itr = mGraphics.begin(), itrEnd = mGraphics.end(); itr != itrEnd; ++itr)
	{
		Graphic* currentGraphic(*itr);
		currentGraphic->Update(deltaTime);
	}
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::GraphicList::OnRender(void) const
{
	for (GraphicContainer::const_iterator itr = mGraphics.begin(), itrEnd = mGraphics.end(); itr != itrEnd; ++itr)
	{
		const Graphic* currentGraphic(*itr);
		tb_error_if(false == currentGraphic->IsRelative(), "tbInternalError: Not yet implemented or supported, maybe in the future.");
		currentGraphic->Render();
	}
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::GraphicList::AddGraphic(TurtleBrains::Graphics::Graphic* graphic)
{
	ReallyAddGraphic(graphic, true);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::GraphicList::AddGraphic(TurtleBrains::Graphics::Graphic& graphic)
{
	ReallyAddGraphic(&graphic, false);
}

//--------------------------------------------------------------------------------------------------------------------//

//TODO: TIM: Optimize: This works great, but it would be even better to make it sort opaque graphics from back to front,
//  then the transparent graphics from front to back to reduce overdraw of opaque.  Would need a flag on the graphics to
//  be set on fully opaque graphics though.
bool GraphicDepthCompare(const tbGraphics::Graphic* const first, const tbGraphics::Graphic* const second)
{
	return first->GetDepth() < second->GetDepth();
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::GraphicList::ReallyAddGraphic(Graphic* graphic, const bool managed)
{
	if (true == managed)
	{
		mManagedGraphics.push_back(graphic);
	}

	// TODO: TIM: Optimize: While this is much better than sorting the entire list each time we add a new graphic it may be
	//   possible to use std::find_if to get the element AFTER the new one and then std::list::insert which will place
	//   before the iterator given.
	GraphicContainer newElement;
	newElement.push_back(graphic);
	mGraphics.merge(newElement, GraphicDepthCompare);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::GraphicList::RemoveGraphic(TurtleBrains::Graphics::Graphic* graphic)
{
	mGraphics.remove(graphic);

	for (GraphicContainer::iterator managedItr = mManagedGraphics.begin(), managedEnd = mManagedGraphics.end(); managedItr != managedEnd; ++managedItr)
	{
		if ((*managedItr) == graphic)
		{
			//mManagedGraphics.remove(graphic);
			mManagedGraphics.erase(managedItr);
			delete graphic;
			break;
		}
	}
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::GraphicList::SetColor(const tbGraphics::Color& newColor)
{
	for (GraphicContainer::iterator graphicIter = mGraphics.begin(), graphicEnd = mGraphics.end(); graphicIter != graphicEnd; ++graphicIter)
	{
		(*graphicIter)->SetColor(newColor);
	}
}

//--------------------------------------------------------------------------------------------------------------------//
