///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#include "tb_line.h"
#include "tb_texture_manager.h"
#include "../core/tb_opengl.h"
#include "implementation/tbi_renderer.h"

//const float tbGraphics::LineContainer::kDefaultLineWidth(1.0f);

//--------------------------------------------------------------------------------------------------------------------//

tbGraphics::LineContainer::LineContainer(void)
	//mLineWidth(1.0f)
{
}

//--------------------------------------------------------------------------------------------------------------------//

tbGraphics::LineContainer::LineContainer(const LineContainer& other) :
	Graphic(other)
	//mLineWidth(other.mLineWidth)
{
}

//--------------------------------------------------------------------------------------------------------------------//

tbGraphics::LineContainer::~LineContainer(void)
{
	mVertices.clear();
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::LineContainer::SetColor(const tbGraphics::Color& newColor)
{
	for (size_t index(0); index < mVertices.size(); ++index)
	{
		mVertices[index].abgr = newColor.GetColorABGR();
	}

	Graphic::SetColor(newColor);
}

//--------------------------------------------------------------------------------------------------------------------//

//void tbGraphics::LineContainer::SetLineWidth(const float lineWidth)
//{
//	mLineWidth = lineWidth;
//}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::LineContainer::OnRender(void) const
{
	if (mVertices.size() >= 2)
	{
		//tb_check_gl_errors(glLineWidth(mLineWidth));
		const tbMath::Vector2& position(GetPosition());

		theTextureManager.BindTexture(kBlankTexture);
		tbImplementation::Renderer::PushMatrix();
		tbImplementation::Renderer::Translate(position.x, position.y, GetDepth());

		tbImplementation::Renderer::Render(tbImplementation::Renderer::kLines, mVertices.data(), mVertices.size());
		tbImplementation::Renderer::PopMatrix();
	}
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::LineContainer::ClearVertices(void)
{
	mVertices.clear();
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::LineContainer::AddVertex(const tbMath::Vector2& position)
{
	tbImplementation::Renderer::Vertex2D vertex = { position.x, position.y, GetColor().GetColorABGR(),   0.0f, 0.0f, };
	mVertices.push_back(vertex);
}

//--------------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------------//

tbGraphics::Line::Line(const tbMath::Vector2& start, const tbMath::Vector2& final, const tbGraphics::Color& color) :
	mStartPosition(start),
	mFinalPosition(final)
{
	SetColor(color);
	AddVertex(mStartPosition);
	AddVertex(mFinalPosition);
}

//--------------------------------------------------------------------------------------------------------------------//

tbGraphics::Line::Line(const Line& other) :
	LineContainer(other),
	mStartPosition(other.mStartPosition),
	mFinalPosition(other.mFinalPosition)
{
}

//--------------------------------------------------------------------------------------------------------------------//

tbGraphics::Line::~Line(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Line::SetStartPosition(const tbMath::Vector2& start)
{
	mStartPosition = start;
	
	ClearVertices();
	AddVertex(mStartPosition);
	AddVertex(mFinalPosition);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Line::SetFinalPosition(const tbMath::Vector2& final)
{
	mFinalPosition = final;

	ClearVertices();
	AddVertex(mStartPosition);
	AddVertex(mFinalPosition);
}

//--------------------------------------------------------------------------------------------------------------------//
