///
/// @file
/// @details This is the start of the sprite manager that will eventually become the TurtleBrains sprite manager.
/// @note This is a very early version of the API, expect to make constant changes until locked in at v1.0.0.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_SpriteMap_h_
#define _TurtleBrains_SpriteMap_h_

#include "tb_sprite.h"

namespace TurtleBrains
{
	namespace Graphics
	{

		///
		///	@details Provides an interface to create sprite frames by index or location for the AnimationSequences or the
		///   TileSystem and will contain a way to efficiently render an array of these sprite frames for the TileSystem.
		///
		class SpriteMap// : public Graphic
		{
		public:
			///
			///	@details Creates a SpriteMap of the given texture which will describe where each SpriteFrame is located when
			///   given a location (column, row) or index.
			///
			/// @param textureHandle The texture that the SpriteMap is refering to.
			/// @param frameWidth The width of each sprite frame in the map, in pixels, on the texture.
			/// @param frameHeight The height of each sprite frame in the map, in pixels, on the texture.
			/// @param spacingX An optional value for horizontal spacing between each sprite frame in pixels.
			/// @param spacingY An optional value for vertical spacing between each sprite frame in pixels.
			/// @param offsetX An optional horizontal offset to the left edge of the first mapped frame, if used the first
			///   row is shifted right horizontally by this amount in pixels.
			/// @param offsetY An optional vertical offset to the top efge of the first mapped frame, if used the first
			///   column is shifted down vertically by this amount in pixels.
			///
			SpriteMap(const TextureHandle& textureHandle, const PixelSpace& frameWidth, const PixelSpace& frameHeight,
				const PixelSpace& spacingX = 0, const PixelSpace& spacingY = 0, const PixelSpace& offsetX = 0, const PixelSpace& offsetY = 0);

			///
			///	@details Destroys and cleans up after the SpriteMap, ?which may include deleting an array of indices?
			///	TODO: TIM: Documentation: Teach the user how to use this.
			///
			virtual ~SpriteMap(void);

			///
			///	@details TODO: TIM: Documentation: Teach the user how to use this.
			///
			SpriteFrame GetSpriteFrameAtIndex(const size_t& frameIndex) const;

			///
			///	@details TODO: TIM: Documentation: Teach the user how to use this.
			///
			SpriteFrame GetSpriteFrameAtLocation(const size_t& frameColumn, const size_t& frameRow) const;

			///
			///	@details TODO: TIM: Documentation: Teach the user how to use this.
			///
			size_t GetIndexCount(void) const;

			///
			///	@details TODO: TIM: Documentation: Teach the user how to use this.
			///
			size_t GetColumnCount(void) const;

			///
			///	@details TODO: TIM: Documentation: Teach the user how to use this.
			///
			size_t GetRowCount(void) const;

			///
			///	@details TODO: TIM: Documentation: Teach the user how to use this.
			///
			PixelSpace GetFrameWidth(void) const;

			///
			///	@details TODO: TIM: Documentation: Teach the user how to use this.
			///
			PixelSpace GetFrameHeight(void) const;

			///
			///	@details TODO: TIM: Documentation: Teach the user how to use this.
			///
			TextureHandle GetTextureHandle(void) const;

			///
			///	@details TODO: TIM: Documentation: Teach the user how to use this.
			///
			void RenderSpritesByIndex(const tbCore::uint16* const spriteArray, const size_t& columnCount, const size_t& rowCount,
				const tbMath::Vector2& position = tbMath::Vector2::kZero) const;

		protected:

		private:
			TextureHandle mTextureHandle;
			PixelSpace mFrameWidth;
			PixelSpace mFrameHeight;
			PixelSpace mSpacingX;
			PixelSpace mSpacingY;
			PixelSpace mOffsetX;
			PixelSpace mOffsetY;
		};


//		///
//		///	@details This is an ordered sequence of SpriteFrame objects that make up an animation for the AnimatedSprite to
//		///   then flip from frame to frame.
//		///
//		/// @note May eventually contain desired flip rate, default looping / pingpong values etc.
//		///
//		class AnimationSequence
//		{
//		public:
//
//			///
//			///	@details Creates an empty AnimationSequence with no frames.  Frames must then be added to the sequence in the
//			///   order desired by calling AddFrame().
//			///
//			/// @param textureHandle All frames added to the AnimationSequence must be on this texture.
//			///
//			/// @note This will trigger an error condition it textureHandle is kInvalidTexture.
//			///
//			explicit AnimationSequence(const TextureHandle& textureHandle);
//
//			///
//			///	@details Creates an AnimationSequence with a custom sequence of mapped frames by breaking down the texture into
//			///   columns and rows based on width/height of the frame and texture, then uses the frames parameter as a
//			///   sequence of indices into that space.  A 512x256 texture, with a 32x32 frame will have 16 columns and 8 rows.
//			///   The index 0 is for the top-left of the texture, the maximum index is (columns * rows) - 1 for the bottom-right
//			///   most frame of the texture.
//			///
//			/// @param textureHandle All frames added to the AnimationSequence must be on this texture.
//			/// @param frameWidth The width of each frame of animation, in pixels, and for the mapped texture columns.
//			/// @param frameHeight The height of each frame of animation, in pixels, and for the mapped texture rows.
//			/// @param frames The customized sequence of indices on the mapped texture columns by rows, starting with top-left
//			///   ending at the bottom-right.
//			/// @param locationX An optional horizontal offset to the first mapped frame, if used the first row is shifted
//			///   right horizontally by this amount in pixels.
//			/// @param locationY An optional vertical offset to the first mapped frame, if used the first column is shifted
//			///   down vertically by this amount in pixels.
//			///
//			/// @note This will trigger an error condition it textureHandle is kInvalidTexture.
//			///
//			AnimationSequence(const TextureHandle& textureHandle, const PixelSpace& frameWidth, const PixelSpace& frameHeight,
//														 const std::vector<size_t> frames, const PixelSpace& locationX = 0, const PixelSpace& locationY = 0);
//
//			///
//			///	@details Creates an AnimationSequence with an ordered sequence of mapped frames by breaking down the texture into
//			///   columns and rows based on width/height of the frame and texture, then uses the frames parameter as a
//			///   sequence of indices into that space.  A 512x256 texture, with a 32x32 frame will have 16 columns and 8 rows.
//			///   The index 0 is for the top-left of the texture, the maximum index is (columns * rows) - 1 for the bottom-right
//			///   most frame of the texture.
//			///
//			/// @param textureHandle All frames added to the AnimationSequence must be on this texture.
//			/// @param frameWidth The width of each frame of animation, in pixels, and for the mapped texture columns.
//			/// @param frameHeight The height of each frame of animation, in pixels, and for the mapped texture rows.
//			/// @param startFrameIndex The first frame of the ordered sequence.
//			/// @param frameCount The number of frames in the sequence, the final frame index will be startFrame + frameCount.
//			/// @param locationX An optional horizontal offset to the first mapped frame, if used the first row is shifted
//			///   right horizontally by this amount in pixels.
//			/// @param locationY An optional vertical offset to the first mapped frame, if used the first column is shifted
//			///   down vertically by this amount in pixels.
//			///
//			/// @note This will trigger an error condition it textureHandle is kInvalidTexture.
//			///
//			AnimationSequence(const TextureHandle& textureHandle, const PixelSpace& frameWidth, const PixelSpace& frameHeight,
//														 const size_t& startFrameIndex, const size_t& frameCount, const PixelSpace& locationX = 0,
//														 const PixelSpace& locationY = 0);
//
//			///
//			///	@details Cleans up after the AnimationSequence by removing the sequence of SpriteFrame objects from memory.
//			///
//			~AnimationSequence(void);
//
//			///
//			/// @details Adds a single custom frame to the end of the sequence.  Each frame will be played in the order added
//			///   to the sequence.  Call AddFrame(); in the order desired.  It is possible to add the same frame multiple
//			///   times as well for any desired effects.
//			///
//			/// @param frame The SpriteFrame object of the next frame in the animation sequence.
//			///
//			void AddFrame(const SpriteFrame& frame);
//
//			///
//			/// @details Builds a SpriteFrame to add to the end of the sequence.  Each frame will be played in the order added
//			///   to the sequence.  Call AddFrame(); in the order desired.  It is possible to add the same frame multiple
//			///   times as well for any desired effects.
//			///
//			/// @param frameX The horizontal pixel location of the left edge of the sprite frame, 0 is the left edge of texture.
//			/// @param frameY The vertical pixel location of the top edge of the sprite frame, 0 is the top edge of texture.
//			/// @param frameWidth The width in pixels of the sprite frame.
//			/// @param frameHeight The height in pixels of the sprite frame.
//			///
//			void AddFrame(const PixelSpace& frameX, const PixelSpace& frameY, const PixelSpace& frameWidth, const PixelSpace& frameHeight);
//
//			///
//			///	@details Returns the number of frames in the AnimationSequence.
//			///
//			size_t GetFrameCount(void) const;
//
//			///
//			///	@details Returns the SpriteFrame at the frameIndex or triggers an error condition if frameIndex is out-of-range.
//			///
//			/// @param frameIndex The index of the SpriteFrame to return, must be in the range: (0 <= frameIndex < GetFrameCount()).
//			///
//			const SpriteFrame& GetFrame(const size_t& frameIndex) const;
//
//		private:
//			//Animation Size: 36 (bytes per frame) * frames + 8 (bytes minimum for this)
//			//This could greatly reduce size by hold SpriteFrame references, but added cost of complexity and easy usage.
//			TextureHandle mTexture;
//			std::vector<SpriteFrame> mAnimationFrames;
//		};


//		///
//		///	@details The AnimatedSprite is a Sprite that contains several AnimationSequences that can be played back to
//		///   flip the frames of the sprite to playback an animation.
//		///
//		class AnimatedSprite : public Sprite
//		{
//		public:
//			///
//			///	@details The default amount of time per frame, in seconds by the animation system.  Currently at 30fps
//			///   in (TurtleBrains v0.2.0).  This may become an integer type that represents the time in milliseconds.
//			///
//			/// @note This may become a time in milliseconds with a maximum of 100 frames per second and a minimum of
//			///   1 frame per second, although this is yet to be decided.
//			///
//			static const float kDefaultTimePerFrame;
//
//			///
//			/// @details Creates an AnimatedSprite with a given sprite frame, all frames of the sequences added to the
//			///   AnimatedSprite must have the same texture handle as this frame or an error condition will be triggered.
//			///
//			/// @param spriteFrame the initial frame of the Sprite containing the TextureHandle that all other frames
//			///   must have in order to be used.
//			///
//			explicit AnimatedSprite(const SpriteFrame& spriteFrame);
//
//			///
//			///	@details Copy constructor to create an animated sprite by copying all sequences from the other object.
//			///
//			/// @param other The AnimatedSprite to copy and mimic.
//			///
//			AnimatedSprite(const AnimatedSprite& other);
//
//			///
//			///	@details Assignment operator for the AnimatedSprite, this will clear any current animation and sequences,
//			///   copy all the sequences from the other object and set the current frame and timers to that other object.
//			///
//			/// @param other The AnimatedSprite to copy and mimic.
//			///
//			AnimatedSprite& operator=(const AnimatedSprite& other);
//
//			///
//			///	@details Destructs the AnimatedSprite object cleaning up the sequences of animations that had been added.
//			///
//			virtual ~AnimatedSprite(void);
//
//			///
//			///	@details Adds a set of frames to the AnimatedSprite so it can be played as an animation using PlayAnimation().
//			///   It is expected that no AnimationSequence has been added with sequenceName and that the sequence has no more
//			///   than 256 frames of animation or an error condition will be triggered.
//			///
//			/// @param sequenceName A name for the animation sequence added so it can be reference later in PlayAnimation
//			///   using the same name.  Must not be an empty string or an error condition will occur, must be different
//			///   than any other sequence that has been added to the animated sprite or an error condition will be triggered.
//			/// @param sequence The sequence of frames that represents the animation.
//			///
//			void AddSequence(const tbCore::tbString& sequenceName, const AnimationSequence& sequence);
//
//			///
//			///	@details Creates an AnimationSequence with the parameters given, literally calling the appropriate
//			///   constructor.  This may be removed from the interface in future versions as it is redundant now.
//			///   Should favor the use of loading json Sprite Sheets in the SpriteManager with animation and sprite data.
//			///
//			/// @param sequenceName A name for the animation sequence added so it can be reference later in PlayAnimation
//			///   using the same name.  Must not be an empty string or an error condition will occur, must be different
//			///   than any other sequence that has been added to the animated sprite or an error condition will be triggered.
//			/// @param frameWidth is the width of the frame in pixels, must be greater than 0.
//			/// @param frameHeight is the height of the frame in in pixels, must be greater than 0.
//			/// @param frames is an ordered container of the frames in the sequences, { 0, 1, 5, 3 }.
//			/// @param locationX is an optional horizontal offset for the mapped sequence, at least one column (frameWidth)
//			///   must exist to the right of locationX: (0 <= locationX <= textureWidth - frameWidth) or error is triggered.
//			/// @param locationY is an optional vertical offset for the mapped sequence, at least one row (frameHeight) must
//			///   exist under the locationY: (0 <= locationY <= textureHeight - frameHeight) or an error will be triggered.
//			///
//			void AddMappedSequence(const tbCore::tbString& sequenceName, const PixelSpace& frameWidth, const PixelSpace& frameHeight,
//				const std::vector<size_t> frames, const PixelSpace& locationX = 0, const PixelSpace& locationY = 0);
//
//			///
//			///	@details Creates an AnimationSequence with the parameters given, literally calling the appropriate
//			///   constructor.  This may be removed from the interface in future versions as it is redundant now.
//			///   Should favor the use of loading json Sprite Sheets in the SpriteManager with animation and sprite data.
//			///
//			/// @param sequenceName A name for the animation sequence added so it can be reference later in PlayAnimation
//			///   using the same name.  Must not be an empty string or an error condition will occur, must be different
//			///   than any other sequence that has been added to the animated sprite or an error condition will be triggered.
//			/// @param frameWidth is the width of the frame in pixels, must be greater than 0.
//			/// @param frameHeight is the height of the frame in in pixels, must be greater than 0.
//			/// @param startFrameIndex The first frame of the ordered sequence.
//			/// @param frameCount The number of frames in the sequence, the final frame index will be startFrame + frameCount.
//			/// @param locationX is an optional horizontal offset for the mapped sequence, at least one column (frameWidth)
//			///   must exist to the right of locationX: (0 <= locationX <= textureWidth - frameWidth) or error is triggered.
//			/// @param locationY is an optional vertical offset for the mapped sequence, at least one row (frameHeight) must
//			///   exist under the locationY: (0 <= locationY <= textureHeight - frameHeight) or an error will be triggered.
//			///
//			void AddMappedSequence(const tbCore::tbString& sequenceName, const PixelSpace& frameWidth, const PixelSpace& frameHeight,
//				const size_t& startFrameIndex, const size_t& frameCount, const PixelSpace& locationX = 0, const PixelSpace& locationY = 0);
//
//			///
//			///	@details Sets the current sequence to the one found by the sequenceName, the sprite is immediately changed to
//			///   the first frame of the sequence, or last if played backwards, and the animation begins the frame timers.
//			///
//			/// @param sequenceName The name of the sequence to play, as it was added in AddSequence().
//			/// @param isLooping Set to true to play a looping animation until either StopAnimation() is called, or another
//			///   animation is started with PlayAnimation().
//			/// @param isForward Set to true to play the animation forward, or false to start from the last frame and play
//			///   backward until the first frame is reached.
//			/// @param timePerFrame Sets the minimum amount of time that a frame should be displayed for before changing to
//			///   the next frame of the animation.  This may be changing to milliseconds in the future, but currently the
//			///   value is in seconds where 1.25 is one and a quarter seconds per frame.
//			///
//			/// @note timePerFrame may become a time in milliseconds with a maximum of 100 frames per second and a minimum of
//			///   1 frame per second, although this is yet to be decided.
//			///
//			void PlayAnimation(const tbCore::tbString& sequenceName, const bool isLooping, const bool isForward = true,
//				const float timePerFrame = kDefaultTimePerFrame);
//
//			///
//			///	@details Sets the current sequence to the one found by the sequenceName, the sprite is immediately changed to
//			///   the first frame of the sequence, or last if played backwards, and the animation begins the frame timers.
//			///
//			/// @param sequenceName The name of the sequence to play, as it was added in AddSequence().
//			///
//			void PlayAnimation(const tbCore::tbString& sequenceName);
//
//			///
//			///	@details Stops the animation on the current frame and stops the frame timers from being processed further.  No
//			///   frames will be switched until PlayAnimation is called again to begin playing.
//			///
//			/// @note The implementation details may change in the future pending the addition of a Pause(), if Pause() is
//			///   introduced, Stop() will stop the animation and set the frame to the first frame of animation.  This is yet
//			///   to be decided.  TODO: TIM: Implementation: Figure out this detail before TurtleBrains public release.
//			///
//			void StopAnimation(void);
//
//			///
//			///	@details Check if the animation is currently playing or if it has reached the end and stopped, or been stopped
//			///   with a call to StopAnimation().  This will always return true for a looping animation!
//			///
//			bool IsAnimationPlaying(void) const;
//
//		protected:
//
//			///
//			///	@details If the animation is paying this will update the frame timers and swap to the next frame if the timer
//			///   has exceeded the maximum time allowed per frame.
//			///
//			virtual void OnUpdate(const float deltaTime) override;
//
//		private:
//			typedef std::map<tbCore::tbString, AnimationSequence> AnimationContainer;
//			AnimationContainer mAnimationSequences;
//
//			const AnimationSequence* mCurrentSequence;
//			size_t mCurrentFrameIndex;
//			float mTimePerFrame;
//			float mFrameTimer;
//			bool mIsPlaying;
//			bool mIsLooping;
//			bool mIsForward;
//
//			//The above could become the following for implementation to save space if it ever becomes a concern, will aim
//			//for mobile at some point with a few, reasonable? restrictions: Animation speed must be 1fps or faster and no
//			//animation can contain more than 256 frames.
//			//
//			// 4 bits: playing, looping, forward, pingpong
//			// 8 bits: currentFrameIndex (0-255)
//			// 10 bits: timePerFrame (milliseconds)
//			// 10 bits: frameTimer (milliseconds)
//		};

	}; /* namespace Graphics */
}; /* namespace TurtleBrains */

namespace tbGraphics = TurtleBrains::Graphics;

#endif /* _TurtleBrains_SpriteMap_h_ */
