///
/// @file
/// @details This is the start of the sprite manager that will eventually become the TurtleBrains sprite manager.
/// @note This is a very early version of the API, expect to make constant changes until locked in at v1.0.0.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#include "tb_sprite_sheet.h"

#include "../core/tb_error.h"

#include <fstream>

tbGraphics::SpriteSheet::SpriteSheet(const TextureHandle& textureHandle) :
	mTextureHandle(textureHandle)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::SpriteSheet::AddSpriteFrame(const tbCore::tbString& spriteName, const SpriteFrame& spriteFrame)
{
	tb_error_if(mSpriteFrames.find(spriteName) != mSpriteFrames.end(),
		"tbExternalError: Attempting to add sprite frame %s which already exists on sprite sheet.", spriteName.c_str());
	tb_error_if(kInvalidTexture == mTextureHandle, "tbExternalError: Cannot add sprite %s without setting a texture first.", spriteName.c_str());
	tb_error_if(spriteFrame.mTexture != mTextureHandle, "tbExternalError: Cannot add sprite %s with different texture than sheet.", spriteName.c_str());
	
	mSpriteFrames[spriteName] = spriteFrame;
}

//--------------------------------------------------------------------------------------------------------------------//

const tbGraphics::SpriteFrame& tbGraphics::SpriteSheet::GetSpriteFrame(const tbCore::tbString& spriteName) const
{
	SpriteFrameContainer::const_iterator frameIterator(mSpriteFrames.find(spriteName));
	tb_error_if(frameIterator == mSpriteFrames.end(), "tbExternalError: Sprite with name %s does not exist on sprite sheet.", spriteName.c_str());
	return frameIterator->second;
}

//--------------------------------------------------------------------------------------------------------------------//

//bool tbGraphics::SpriteSheet::HasSpriteFrame(const tbCore::tbString& spriteName) const
//{
//	SpriteFrameContainer::const_iterator frameIterator(mSpriteFrames.find(spriteName));
//	return (frameIterator == mSpriteFrames.end()) ? false : true;
//}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::SpriteSheet::AddAnimationSequence(const tbCore::tbString &animationName, const AnimationSequence &animationSequence)
{
	tb_error_if(mAnimationSequences.find(animationName) != mAnimationSequences.end(),
		"tbExternalError: Attempting to add animation %s which already exists on sprite sheet.", animationName.c_str());

	mAnimationSequences.insert(AnimationSequenceContainer::value_type(animationName, animationSequence));
}

//--------------------------------------------------------------------------------------------------------------------//

const tbGraphics::AnimationSequence& tbGraphics::SpriteSheet::GetAnimationSequence(const tbCore::tbString& animationName) const
{
	AnimationSequenceContainer::const_iterator animationIterator(mAnimationSequences.find(animationName));
	tb_error_if(animationIterator == mAnimationSequences.end(), "tbExternalError: Animation with name %s does not exist in sprite sheet.", animationName.c_str());
	return animationIterator->second;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::SpriteSheet::AddAnimationSequencesToSprite(const tbCore::tbString& spriteName, const std::vector<tbCore::tbString>& animationNames)
{
	tb_error_if(mSpriteAnimations.find(spriteName) != mSpriteAnimations.end(),
							"tbExternalError: Attempting to add animation %s which already exists on sprite sheet.", spriteName.c_str());

	mSpriteAnimations[spriteName] = animationNames;
}

//--------------------------------------------------------------------------------------------------------------------//

bool tbGraphics::SpriteSheet::HasAnimationsForSprite(const tbCore::tbString& spriteName) const
{
	return (mSpriteAnimations.find(spriteName) != mSpriteAnimations.end()) ? true : false;
}

//--------------------------------------------------------------------------------------------------------------------//

const std::vector<tbCore::tbString>& tbGraphics::SpriteSheet::GetAnimationsForSprite(const tbCore::tbString& spriteName) const
{
	return mSpriteAnimations.at(spriteName);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::SpriteSheet::SetTextureHandle(const tbGraphics::TextureHandle& textureHandle)
{
	mTextureHandle = textureHandle;
}

//--------------------------------------------------------------------------------------------------------------------//

const tbGraphics::TextureHandle& tbGraphics::SpriteSheet::GetTextureHandle(void) const
{
	return mTextureHandle;
}

//--------------------------------------------------------------------------------------------------------------------//
