///
/// @file
/// @details This is the start of the sprite manager that will eventually become the TurtleBrains sprite manager.
/// @note This is a very early version of the API, expect to make constant changes until locked in at v1.0.0.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_SpriteSheet_h_
#define _TurtleBrains_SpriteSheet_h_

#include "tb_sprite.h"					//for SpriteFrame
#include "tb_animated_sprite.h" //for AnimationSequence
#include "tb_texture_manager.h"
#include "../core/tb_string.h"

#include <map>

namespace TurtleBrains
{
	namespace Graphics
	{

		///
		///	@details A sprite sheet is a collection of information regarding the sprites on a particular texture file.
		///   Each Sprite has a sprite frame, location and size on the texture and can optionally have animation sequences
		///   as well.  It would be rare for the Spritesheet objects tb be used directly as the SpriteManager handles the
		///   loading of the sprite sheets as well as the creation of the Sprite objects and AnimatedSprite objects.
		///
		/// @note This shall be considered a TurtleBrains implementation detail.  Until further notice do not use the
		///   SpriteSheet directly or risk future changes/access loss.
		///
		class SpriteSheet
		{
		public:
			///
			///	@details This is an implementation detail of the SpriteManager and should not be used directly.
			/// @note The SpriteSheet must have a valid texture before any SpriteFrame objects can be added			
			///
			explicit SpriteSheet(const TextureHandle& textureHandle = kInvalidTexture);

			///
			///	@details This is an implementation detail of the SpriteManager and should not be used directly.
			/// @note The SpriteSheet must have a valid texture before any SpriteFrame objects can be added otherwise an
			///   error condition will be triggered.  Each SpriteFrame must have the exact TextureHandle or an error condition
			///   will be triggered.
			///
			void AddSpriteFrame(const tbCore::tbString& spriteName, const SpriteFrame& spriteFrame);

			///
			///	@details This is an implementation detail of the SpriteManager and should not be used directly.
			/// @note If no sprite data exists on the sheet for the spriteName provided an error condition will be triggered.
			///
			const SpriteFrame& GetSpriteFrame(const tbCore::tbString& spriteName) const;

			///
			///	@details This is an implementation detail of the SpriteManager and should not be used directly.
			///
			void AddAnimationSequence(const tbCore::tbString& animationName, const AnimationSequence& animationSequence);

			///
			///	@details This is an implementation detail of the SpriteManager and should not be used directly.
			/// @note If no animation sequence exists on the for animationeName an error condition will be triggered.
			///
			const AnimationSequence& GetAnimationSequence(const tbCore::tbString& animationName) const;

			///
			///	@details This is an implementation detail of the SpriteManager and should not be used directly.
			///
			void AddAnimationSequencesToSprite(const tbCore::tbString& spriteName, const std::vector<tbCore::tbString>& animationNames);

			///
			///	@details This is an implementation detail of the SpriteManager and should not be used directly.
			///
			bool HasAnimationsForSprite(const tbCore::tbString& spriteName) const;

			///
			///	@details This is an implementation detail of the SpriteManager and should not be used directly.
			///
			const std::vector<tbCore::tbString>& GetAnimationsForSprite(const tbCore::tbString& spriteName) const;

			///
			///	@details This is an implementation detail of the SpriteManager and should not be used directly.
			/// @note The SpriteSheet must have a valid texture before any SpriteFrame objects can be added.
			///
			void SetTextureHandle(const TextureHandle& textureHandle);

			///
			/// @details This is an implementation detail of the SpriteManager and should not be used directly.
			///
			const TextureHandle& GetTextureHandle(void) const;

		private:
			typedef std::map<tbCore::tbString, SpriteFrame> SpriteFrameContainer;
			SpriteFrameContainer mSpriteFrames;
			typedef std::map<tbCore::tbString, AnimationSequence> AnimationSequenceContainer;
			AnimationSequenceContainer mAnimationSequences;
			typedef std::map<tbCore::tbString, std::vector<tbCore::tbString> > SpriteAnimationsContainer;
			SpriteAnimationsContainer mSpriteAnimations;
			TextureHandle mTextureHandle;
		};

	}; /* namespace Graphics */
}; /* namespace TurtleBrains */

namespace tbGraphics = TurtleBrains::Graphics;

#endif /* _TurtleBrains_SpriteSheet_h_ */
