///
/// @file
/// @details An capture/exporter from game to GIF.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_GifExporter_h_
#define _TurtleBrains_GifExporter_h_

namespace TurtleBrains
{
	namespace Graphics
	{
		namespace Unstable
		{
			///
			/// @details This is the only function that needs to be called, once per frame during Update().
			///
			/// @param deltaTime The amount of time since the previous call to PerformCapture.
			/// @param toggleCapture True if the capture state should be toggled on/off or off/on depending on the current
			///   state. Typically this would be a value from IsKeyPressed().
			///
			void GifPerformCapture(const float deltaTime, const bool toggleCaptureState);

			///
			///
			///
			void GifCaptureCleanup(void);

			//Implementation Details Below.

			///None of this should be needed, perhaps an GifInitialize() and GifCleanup()?
			void GifStartCapture(void);
			void GifCaptureFrame(void);
			void GifUpdateCapture(const float deltaTime);
			void GifFinalCapture(void);

			void GifJoinThread(void);

		}; /* namespace Unstable */
	}; /* namespace Graphics */
}; /* namespace TurtleBrains */

namespace tbGraphics = TurtleBrains::Graphics;

#endif /* _TurtleBrains_GifExporter_h_ */
