///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrainsUnstable_BoundingVolume_h_
#define _TurtleBrainsUnstable_BoundingVolume_h_

#include "../../math/tb_vector.h" //For Vector2

namespace TurtleBrains
{
	namespace Math
	{
		namespace Unstable
		{

			///
			/// @details TODO: TIM: Documentation: Teach the user how to use this.
			///
			class BoundingVolume
			{
			public:
				///
				///	@details Constructs a Circle shaped bounding volume with the given radius.
				///
				/// @param radius The radius of the circle to use for bounding an object, must be greater than 0 or an error will be
				///   triggered.  The units are technically undetermined but may often correlate with pixels as in with the Entity.
				///
				explicit BoundingVolume(float radius);

				///
				///	@details Constructs a Box shaped bounding volume with the given width and height.
				///
				/// @param width The horizontal width of the objects bounding box, must be greater than 0 or an error will be
				///   triggered.  The units are technically undetermined but may often correlate with pixels as in with the Entity.
				/// @param height The vertical height of the objects bounding box, , must be greater than 0 or an error will be
				///   triggered.  The units are technically undetermined but may often correlate with pixels as in with the Entity.
				///
				explicit BoundingVolume(float width, float height);

				///
				///	@details Destructs a BoundingVolume object which currently (TurtleBrains v0.2.0) does not have any resources to
				///   clean up after.
				///
				~BoundingVolume(void);

				///
				///	@details Returns true if this BoundingVolume is a bounding circle, otherwise false is returned.
				///
				bool IsCircle(void) const;

				///
				///	@details Returns true if this BoundingVolume is a bounding box, otherwise false is returned.
				///
				bool IsBox(void) const;

				///
				///	@details Checks to see if a point exists in the bounding volume and returns true if the testPoint
				///   is found inside the bounding volume, or false if outside.
				///
				/// @param objectPosition The position of this bounding volume to check the collision with the testPoint.
				/// @param testPoint A single point to check if the position is located within this bounding volume.
				///
				bool CheckCollisionWith(const tbMath::Vector2& objectPosition, const tbMath::Vector2& testPoint) const;

				///
				///	@details Checks to see if two bounding volumes are colliding and returns true if the volumes are
				///   intersecting, or false if there is no parts intersecting.
				///
				/// @param objectPosition The position of this bounding volume to check the collision with the other volume.
				/// @param testVolume The other bounding volume to check if any parts are intersecting with this volume.
				/// @param testVolumePosition The position of the other bounding volume to check for intersection.
				///
				bool CheckCollisionWith(const tbMath::Vector2& objectPosition, const BoundingVolume& testVolume, const tbMath::Vector2& testVolumePosition) const;

				///
				/// @details Attempts to move objectPosition so this bounding volume won't collide with the
				///   staticVolume at staticVolumePosition. Currently only works with two box volumes, other volumes
				///   will return false. The oobjectPosition will move along the axis with least penetration.
				///
				/// @param objectPosition The position of this bounding volume to resolve the collision with. It is
				///   expected that the collision has already been checked and is in an intersected state with staticVolume.
				///   This parameter will be modified internally and returned as the new position of the bounding volume.
				/// @param staticVolume The other bounding volume to resolve collision against, which does NOT move.
				/// @param staticVolumePosition The position of the other bounding volume.
				///
				/// @note This implementation is still very unstable and incomplete. Both bounding volumes must be a box.
				///
				bool ResolveCollisionWithStatic(tbMath::Vector2& objectPosition, const BoundingVolume& staticVolume, const tbMath::Vector2& staticVolumePosition) const;

				///
				/// @details Returns the radius of a circular bounding volume. This will trigger an error condition if
				///   the bounding volume is not a circle.
				///
				float GetRadius(void) const { tb_error_if(false == IsCircle(), "tbExternalError: This bounding volume is not a circle."); return mWidth; }

				///
				/// @details Returns the width of a box bounding volume. This will trigger an error condition if
				///   the bounding volume is not a box.
				///
				float GetWidth(void) const { tb_error_if(false == IsBox(), "tbExternalError: This bounding volume is not a box."); return mWidth; }

				///
				/// @details Returns the height of a box bounding volume. This will trigger an error condition if
				///   the bounding volume is not a box.
				///
				float GetHeight(void) const { tb_error_if(false == IsBox(), "tbExternalError: This bounding volume is not a box."); return mHeight; }

			private:
				float mWidth;
				float mHeight;
			};

		}; /* namespace Unstable */
	}; /* namespace Math */
}; /* namespace TurtleBrains */

namespace tbMath = TurtleBrains::Math;

#endif /* _TurtleBrainsUnstable_BoundingVolume_h_ */
