///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#include "tb_system_timer.h"
#include "../core/tb_configuration.h"

#if defined(tb_windows)
	#include <windows.h>
#else
  #include <chrono>
#endif

namespace tbiTimer
{
#if defined(tb_windows)
	LARGE_INTEGER tbiFrequency;
	LARGE_INTEGER tbiTickCount;
	LARGE_INTEGER tbiTickStart;
#elif defined(tb_macosx) || defined(tb_linux)
	typedef std::chrono::high_resolution_clock PreciseClock;
	PreciseClock::time_point tbiStartTime;
#else
	#error This configuration is currently unsupported by TurtleBrains.
#endif

	tbSystem::Timer::Seconds tbiTotalTime;
	tbSystem::Timer::Seconds tbiDeltaTime;
};

//--------------------------------------------------------------------------------------------------------------------//

void tbSystem::Timer::Reset(void)
{
#if defined(tb_windows)
	QueryPerformanceFrequency(&tbiTimer::tbiFrequency);
	QueryPerformanceCounter(&tbiTimer::tbiTickCount);
	QueryPerformanceCounter(&tbiTimer::tbiTickStart);
#elif defined(tb_macosx) || defined(tb_linux)
	tbiTimer::tbiStartTime = tbiTimer::PreciseClock::now();
#else
	#error This configuration is currently unsupported by TurtleBrains.
#endif

	tbiTimer::tbiTotalTime = 0.0;
	tbiTimer::tbiDeltaTime = 0.0;

	Update();
}

//--------------------------------------------------------------------------------------------------------------------//

void tbSystem::Timer::Update(void)
{
	Seconds currentTime(0.0);
	
#if defined(tb_windows)
	QueryPerformanceCounter(&tbiTimer::tbiTickCount);
	currentTime = (static_cast<double>(tbiTimer::tbiTickCount.QuadPart) - static_cast<double>(tbiTimer::tbiTickStart.QuadPart)) / static_cast<double>(tbiTimer::tbiFrequency.QuadPart);
#elif defined(tb_macosx) || defined(tb_linux)
	tbiTimer::PreciseClock::time_point timeNow = tbiTimer::PreciseClock::now();
	std::chrono::duration<double> elapsed = std::chrono::duration_cast<std::chrono::duration<double> >(timeNow - tbiTimer::tbiStartTime);
	currentTime = elapsed.count();
#else
	#error This configuration is currently unsupported by TurtleBrains.
#endif

	tbiTimer::tbiDeltaTime = (currentTime - tbiTimer::tbiTotalTime);
	tbiTimer::tbiTotalTime = currentTime;
}

//--------------------------------------------------------------------------------------------------------------------//

tbSystem::Timer::Seconds tbSystem::Timer::GetDeltaTime(void)
{
	return tbiTimer::tbiDeltaTime;
}

//--------------------------------------------------------------------------------------------------------------------//

tbSystem::Timer::Seconds tbSystem::Timer::GetTotalTime(void)
{
	return tbiTimer::tbiTotalTime;
}

//--------------------------------------------------------------------------------------------------------------------//


//
//tbGame::Timer::Timer(void) :
//	mElapsedTime(0.0),
//	mDeltaTime(0.0)
//{
//	Reset();
//}
//
////--------------------------------------------------------------------------------------------------------------------//
//
//tbGame::Timer::~Timer(void)
//{
//}
//
////--------------------------------------------------------------------------------------------------------------------//
//
//void tbGame::Timer::Update(void)
//{
//	const double currentElapsed = mElapsedTime;
//
//	typedef std::chrono::high_resolution_clock PreciseClock;
//	static PreciseClock::time_point startTime = PreciseClock::now();
//	PreciseClock::time_point currentTime = PreciseClock::now();
//
//	std::chrono::duration<double> elapsed = std::chrono::duration_cast<std::chrono::duration<double>>(currentTime - startTime);
//	mElapsedTime = elapsed.count();
//
//	mDeltaTime = mElapsedTime - currentElapsed;
//}
//
////--------------------------------------------------------------------------------------------------------------------//
//
//void tbGame::Timer::Reset(void)
//{
//	mElapsedTime = 0.0;
//	Update();
//	mDeltaTime = 0.0;
//}
//
////--------------------------------------------------------------------------------------------------------------------//
//
//double tbGame::Timer::GetElapsedTime(void) const
//{
//	return mElapsedTime;
//}
//
////--------------------------------------------------------------------------------------------------------------------//
//
//double tbGame::Timer::GetDeltaTime(void) const
//{
//	return mDeltaTime;
//}
//


//--------------------------------------------------------------------------------------------------------------------//

tbSystem::Timer::Timer::Timer(void) :
	mStartTime(0),
	mCurrentTime(0),
	mDeltaTime(0)
{
}

//--------------------------------------------------------------------------------------------------------------------//

tbSystem::Timer::Timer::~Timer(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void tbSystem::Timer::Timer::Reset(void)
{
	mStartTime = mCurrentTime = tbSystem::Timer::GetTotalTime();
	mDeltaTime = 0;
	Update();
}

//--------------------------------------------------------------------------------------------------------------------//

void tbSystem::Timer::Timer::Update(void)
{
	tbSystem::Timer::Seconds previousTime = mCurrentTime;
	tbSystem::Timer::Update();
	mCurrentTime = tbSystem::Timer::GetTotalTime();
	mDeltaTime = mCurrentTime - previousTime;
}

//--------------------------------------------------------------------------------------------------------------------//

tbSystem::Timer::Seconds tbSystem::Timer::Timer::GetDeltaTime(void)
{
	return mDeltaTime;
}

//--------------------------------------------------------------------------------------------------------------------//

tbSystem::Timer::Seconds tbSystem::Timer::Timer::GetTotalTime(void)
{
	tbSystem::Timer::Update();
	mCurrentTime = tbSystem::Timer::GetTotalTime();
	return mCurrentTime - mStartTime;
}

//--------------------------------------------------------------------------------------------------------------------//
