///
/// @file
/// @details The GraphicsKit header includes all classes, objects and functions that exist in TurtleBrains::Graphics 
///   for easy include purposes.  Instead of including each file individually, just include tb_graphics_kit and the rest
///   of the headers come with it.
///
/// @note Including this file may create slightly longer compile times, particularly when doing a full rebuild of a 
///   project since more files are included than are likely actually needed.  However, the easy and quick usage to get
///   up and running without worrying is worth the cost.  Internal TurtleBrains files will never include a "kit" in
///   order keep the compile times down for those who include only what is needed by their project.  This is optional.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_GraphicsKit_h_
#define _TurtleBrains_GraphicsKit_h_

#include "graphics/tb_color.h"
#include "graphics/tb_graphic.h"
#include "graphics/tb_basic_shapes.h"
#include "graphics/tb_text.h"
#include "graphics/tb_sprite.h"
#include "graphics/tb_animated_sprite.h"
#include "graphics/tb_sprite_map.h"
#include "graphics/tb_graphic_list.h"
#include "graphics/tb_sprite_manager.h"
#include "graphics/tb_texture_manager.h"

#endif /* _TurtleBrains_GraphicsKit_h_ */
