///
/// @file
/// @details An entity within the LudumDare37 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare37_ButtonEntity_h_
#define _LudumDare37_ButtonEntity_h_

#include "ludumdare37.h"

class ButtonEntity : public tbGame::Entity
{
public:
	enum class ButtonState
	{
		kDisabled,
		kEnabled,
		kHoverOver,
	};

	ButtonEntity(void);
	virtual ~ButtonEntity(void);

	void SetOrigin(const tbGraphics::AnchorLocation& anchor);

	void SetButtonSprites(const tbGraphics::Sprite& buttonSprite, const tbGraphics::Sprite& hoverSprite, const tbGraphics::Sprite& disabledSprite);
	void SetButtonState(const ButtonState& buttonState);
	const ButtonState& GetButtonState(void) const;
	void SetInputOffset(const tbMath::Vector2& inputOffset);

protected:
	virtual void OnAdded(void) override;
	virtual void OnRemoved(void) override;
	virtual void OnSimulate(void) override;
	virtual void OnUpdate(const float deltaTime) override;
	virtual void OnRender(void) const override;
	virtual void OnCollideWith(tbGame::Entity& otherEntity) override;

protected:
	bool IsMouseOver(void) const;
	virtual void OnClicked(void);

	tbGraphics::Sprite mButtonSprite;
	tbGraphics::Sprite mDisabledSprite;
	tbGraphics::Sprite mHoverOverSprite;
	tbCore::tbString mOnMoveOverAudioEvent;
	tbCore::tbString mOnMoveOutAudioEvent;
	tbCore::tbString mOnClickAudioEvent;

private:
	ButtonState mCurrentState;

	tbMath::Vector2 mInputOffset; //Seemed to be needed for BLAH annoying.
	tbMath::Vector2 mButtonTopLeft;
	tbMath::Vector2 mButtonBottomRight;
};

#endif /* _LudumDare37_ButtonEntity_h_ */
