///
/// @file
/// @details A way to store and set results, like current/best score for the LudumDare37 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare37_GameResults_h_
#define _LudumDare37_GameResults_h_

#include "ludumdare37.h"

#include <stdint.h>

namespace GameResults
{
	void ResetGameResults(bool includingBest);

	uint32_t GetCurrentScore(void);
	uint32_t GetBestScore(void);

	void IncrementCurrentScore(const uint32_t& increaseAmount = 1);

	void IncrementHoursSpentInRoom(void);
	uint32_t GetHoursSpentInRoom(void);
	uint32_t GetMostHoursSpentInRoom(void);

	void IncrementMonsterKillCount(void);
	uint32_t GetMonsterKillCount(void);
	uint32_t GetBestMonsterKillCount(void);

	void SetWinFlag(bool didWin);
	bool GetWinFlag(void);
};

#endif /* _LudumDare37_GameResults_h_ */
