///
/// @file
/// @details This scene is the gameplay scene for the LudumDare37 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare37_GameplayScene_h_
#define _LudumDare37_GameplayScene_h_

#include "ludumdare37.h"
#include "haunted_room_entity.h"
#include "spellbook_entity.h"
#include "stay_or_leave_prompt.h"

class GameplayScene : public tbGame::GameScene
{
public:
	GameplayScene(void);
	virtual ~GameplayScene(void);

	virtual void OnSimulate(void) override;
	virtual void OnUpdate(const float deltaTime) override;
	virtual void OnRender(void) const override;
	virtual void OnOpen(void) override;
	virtual void OnClose(void) override;

	void StayInRoomForAnotherHour(void);
	void LeaveRoomLikeAChicken(void);

protected:

private:
	StayOrLeavePrompt mStayOrLeavePrompt;
	SpellbookEntity mSpellbook;
	HauntedRoomEntity mHauntedRoom;
};

#endif /* _LudumDare37_GameplayScene_h_ */
