///
/// @file
/// @details An entity within the LudumDare37 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare37_HauntedRoomEntity_h_
#define _LudumDare37_HauntedRoomEntity_h_

#include "ludumdare37.h"
#include "target_entity.h"
#include "monster_entity.h"
#include "spellbook_entity.h"

class HauntedRoomEntity : public tbGame::Entity
{
public:
	HauntedRoomEntity(void);
	virtual ~HauntedRoomEntity(void);

	///Clears target and combat situation.
	void ResetToEmptyRoom(void);

	bool IsInCombat(void) const;

	/// Enter a combat because the player stayed in the room for another hour.
	void EnterCombat(const int hoursSpentInRoom);

	int NumberOfMonsters(void) const { return mCombatTargets.size(); }

	void SetCanTargetMonster(const bool canTargetMonster);
	bool IsMonsterTargetted(void) const;
	bool IsMonsterTargetted(const MonsterEntity& monster, const SpellSchool& bySpell) const;

	void SetTargetToMonster(MonsterEntity& targettedMonster);
	void ClearTargettedMonster(void);
	void ShowAllAvailableTargets(void);
	void ShowNoAvailableTargets(void);

	void SetPreppedSpellSchool(const SpellSchool& spellSchool);
	void SetCastedSpellSchool(const SpellSchool& spellSchool);
	void SpellCastedOnTargets(void); //Uses casted spell.
	bool IsDamageBeingDealt(void) const;

	void MonstersAttackStudent(void);
	bool IsKillingStudent(void) const;
	bool CanKillStudent(void) const { return mCanKillPlayer; }

	void RecalculateNextCombatMonsterCount(void);
	int NumberMonstersInRoomForNextCombat(void) const;

protected:
	virtual void OnAdded(void) override;
	virtual void OnRemoved(void) override;
	virtual void OnSimulate(void) override;
	virtual void OnUpdate(const float deltaTime) override;
	virtual void OnRender(void) const override;
	virtual void OnCollideWith(tbGame::Entity& otherEntity) override;

private:
	std::list<MonsterEntity*> mCombatTargets;
	
	bool mCanKillPlayer;
	bool mCanTargetMonster;
	bool mIsMonsterTargetted;
	int mNumberMonstersForNextCombat;
	MonsterType mTargettedMonsterType;
	MonsterEntity* mTargettedMonster;
	SpellSchool mPreppedSpellSchool;
	SpellSchool mCastedSpellSchool;

	tbGame::GameTimer mDealDamageTimer;
	tbGame::GameTimer mKillPlayerTimer;
};

#endif /* _LudumDare37_HauntedRoomEntity_h_ */
