///
/// @file
/// @details An entity within the LudumDare37 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare37_MonsterEntity_h_
#define _LudumDare37_MonsterEntity_h_

#include "target_entity.h"

enum MonsterType
{
	kMonsterSlimeBall,
	kMonsterGoblin,
	kMonsterSkeleton,
	kMonsterTreasureChest,
	kMonsterInvalid
};

static const size_t kMaximumMonsterTypes = 4;

class MonsterEntity : public TargetEntity
{
public:
	MonsterEntity(HauntedRoomEntity& hauntedRoom, const MonsterType& monsterType);
	virtual ~MonsterEntity(void);

	const MonsterType& GetMonsterType(void) const { return mMonsterType; }
	
	void SetToAttack(void);
	void SetToDie(void);

	void PlayAnimation(const tbCore::tbString& animationName, const bool isLooping = true, const bool isForward = true,
		const float timePerFrame = tbGraphics::AnimatedSprite::kDefaultTimePerFrame);

protected:

private:
	const MonsterType mMonsterType;
	const tbCore::tbString mAnimationPrefix;
	tbGraphics::AnimatedSprite mMonsterSprite;
};

#endif /* _LudumDare37_MonsterEntity_h_ */
