///
/// @file
/// @details An entity within the LudumDare37 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#include "target_entity.h"

//--------------------------------------------------------------------------------------------------------------------//
const float kTargetScaling(0.75f);

TargetEntity::TargetEntity(HauntedRoomEntity& hauntedRoom) :
	tbGame::Entity("TargetEntity"),
	mHauntedRoom(hauntedRoom),
	mTargetReticleSprite("monster_sheet", "target_reticle")
{
	mTargetReticleSprite.SetDepth(1.0f);
	mTargetReticleSprite.SetScale(kTargetScaling);
	AddGraphic(mTargetReticleSprite);
	//RemoveTargetReticle();

	//SetButtonSprites(tbGraphics::Sprite("monster_sheet", "target_button"))
	ShowAsUnavailable();
}

//--------------------------------------------------------------------------------------------------------------------//

TargetEntity::~TargetEntity(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void TargetEntity::ShowAsUnavailable(void)
{
	mTargetReticleSprite.SetVisible(false);
}

//--------------------------------------------------------------------------------------------------------------------//

void TargetEntity::ShowAsAvailable(void)
{
	mTargetReticleSprite.SetVisible(true);
	mTargetReticleSprite.SetColor(tbGraphics::Color(0xFF808080));
}

//--------------------------------------------------------------------------------------------------------------------//

void TargetEntity::ShowAsSelected(void)
{
	mTargetReticleSprite.SetVisible(true);
	mTargetReticleSprite.SetColor(tbGraphics::Color::kWhite);
}

//--------------------------------------------------------------------------------------------------------------------//

bool TargetEntity::IsMouseOver(void) const
{
	int mouseX(0);
	int mouseY(0);

	tbApplication::Input::GetMousePosition(&mouseX, &mouseY);
	const tbMath::Vector2 mousePosition(static_cast<float>(mouseX), static_cast<float>(mouseY));
	const tbMath::Vector2& position(GetPosition());

	if (mousePosition.x >= position.x + 0 && mousePosition.x <= position.x + 128 * kTargetScaling &&
		mousePosition.y >= position.y + 0 && mousePosition.y <= position.y + 128 * kTargetScaling)
	{
		return true;
	}

	return false;
}

//--------------------------------------------------------------------------------------------------------------------//
