///
/// @file
/// @details An entity within the LudumDare37 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare37_TargetEntity_h_
#define _LudumDare37_TargetEntity_h_

#include "ludumdare37.h"
#include "button_entity.h"

class HauntedRoomEntity;

class TargetEntity : public tbGame::Entity
{
public:
	TargetEntity(HauntedRoomEntity& hauntedRoom);
	virtual ~TargetEntity(void);

	void ShowAsUnavailable(void);
	void ShowAsAvailable(void);
	void ShowAsSelected(void);

	bool IsMouseOver(void) const;

protected:

private:
	HauntedRoomEntity& mHauntedRoom;
	tbGraphics::Sprite mTargetReticleSprite;
};

#endif /* _LudumDare37_TargetEntity_h_ */
