///
/// @file
/// @details Provide a simple title scene for the LudumDare37 project that will fade out into gameplay.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#include "title_scene.h"
#include "scene_manager.h"

const tbGame::GameTimer kMaximumFadeInTime(500);
const tbGame::GameTimer kMaximumFadeOutTime(500);

//--------------------------------------------------------------------------------------------------------------------//

TitleScene::TitleScene(void) :
	mFadeInTimer(kMaximumFadeInTime),
	mFadeOutTimer(0)
{
	AddGraphic(new tbGraphics::Sprite("data/haunted_room_title_screen.png"));

	tbGraphics::Text* titleText = new tbGraphics::Text("Haunted Room", 85.0f);
	titleText->SetOrigin(tbGraphics::kAnchorCenter);
	titleText->SetPosition(tbGraphics::ScreenCenter().x, 700.0f - titleText->GetHeight());
	AddGraphic(titleText);

	mQuitGameAction.AddBinding(tbApplication::tbKeyEscape);
	mStartGameAction.AddBinding(tbApplication::tbKeySpace);
	mStartGameAction.AddBinding(tbApplication::tbMouseLeft);
}

//--------------------------------------------------------------------------------------------------------------------//

TitleScene::~TitleScene(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void TitleScene::OnSimulate(void)
{
	if (false == mFadeInTimer.IsZero())
	{
		float percentage = mFadeInTimer.GetPercentageOf(kMaximumFadeInTime);
		tbGraphics::Color fadingColor;
		fadingColor.SetColor(percentage, tbGraphics::Color::kAlphaFull, tbGraphics::Color::kAlphaNone);
		SetColor(fadingColor);

		if (true == mFadeInTimer.DecrementStep())
		{
			SetColor(tbGraphics::Color::kAlphaFull);
		}
	}

	if (false == mFadeOutTimer.IsZero())
	{
		float percentage = mFadeOutTimer.GetPercentageOf(kMaximumFadeOutTime);
		tbGraphics::Color fadingColor;
		fadingColor.SetColor(percentage, tbGraphics::Color::kAlphaNone, tbGraphics::Color::kAlphaFull);
		SetColor(fadingColor);

		if (true == mFadeOutTimer.DecrementStep())
		{
			SetColor(tbGraphics::Color::kAlphaNone);
			LudumDare37::theSceneManager->ChangeToScene(SceneId::kGameplayScene);
		}
	}
	else
	{
		if (true == mStartGameAction.IsPressed())
		{
			mFadeOutTimer = kMaximumFadeOutTime;
		}
	}

	if (true == mQuitGameAction.IsReleased())
	{
		LudumDare37::theSceneManager->QuitGame();
	}

	tbGame::GameScene::OnSimulate();
}

//--------------------------------------------------------------------------------------------------------------------//

void TitleScene::OnUpdate(const float deltaTime)
{
	tbGame::GameScene::OnUpdate(deltaTime);
}

//--------------------------------------------------------------------------------------------------------------------//

void TitleScene::OnRender(void) const
{
	tbGame::GameScene::OnRender();
}

//--------------------------------------------------------------------------------------------------------------------//

void TitleScene::OnOpen(void)
{
	mFadeInTimer = kMaximumFadeInTime;
	mFadeOutTimer = 0;
	SetColor(tbGraphics::Color::kAlphaNone);
}

//--------------------------------------------------------------------------------------------------------------------//

void TitleScene::OnClose(void)
{
	tbGame::GameScene::OnClose();
}

//--------------------------------------------------------------------------------------------------------------------//

