///
/// @file
/// @details Entry point of the LudumDare37 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#include "ludumdare37.h"
#include "scene_manager.h"

#include <ctime>

//--------------------------------------------------------------------------------------------------------------------//

int real_main(int argumentCount, const char* argumentValues[])
{
	tbMath::SeedRandomGenerator(static_cast<unsigned int>(time(nullptr)));

	tbGame::GameApplication gameApplication;
	gameApplication.SetWindowTitle(tb_string("Haunted Room"));

	tbGraphics::theSpriteManager.LoadSpriteSheetFromFile("game_sheet", "data/game_sheet.json");
	tbGraphics::theSpriteManager.LoadSpriteSheetFromFile("spellbook_sheet", "data/spellbook_sheet.json");
	tbGraphics::theSpriteManager.LoadSpriteSheetFromFile("monster_sheet", "data/monster_sheet.json");
	tbGraphics::theSpriteManager.LoadSpriteSheetFromFile("concept_art", "data/concept_kit/concept_art_sheet.json");
	tbAudio::theAudioManager.LoadEventTable("concept_audio", "data/concept_kit/concept_audio_events.json");
	tbAudio::theAudioManager.LoadEventTable("audio_events", "data/audio/audio_events.json");

	SceneManager::CreateSceneManager();

#if defined(tb_release_build)
	gameApplication.RunGame(SceneManager::GetScene(SceneId::kSplashScene));
#else
	gameApplication.RunGame(SceneManager::GetScene(SceneId::kGameplayScene));
#endif

	SceneManager::DestroySceneManager();

	return 0;
}

//--------------------------------------------------------------------------------------------------------------------//

int main(const int argumentCount, const char* argumentValues[])
{
	tb_log_open("debug_log.txt", true);
	tb_log("Started: LudumDare37\n");

	int returnCode = tb_debug_project_entry_point_with(real_main, argumentCount, argumentValues);

	tb_log("Clean shutdown.\n");
	tb_log_close();
	return returnCode;
}

//--------------------------------------------------------------------------------------------------------------------//
