///
/// @file
/// @details Provide a simple title scene for the LudumDare37 project that will fade out into gameplay.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare37_ResultsScene_h_
#define _LudumDare37_ResultsScene_h_

#include "ludumdare37.h"

class ResultsScene : public tbGame::GameScene
{
public:
	ResultsScene(void);
	virtual ~ResultsScene(void);

protected:
	virtual void OnSimulate(void) override;
	virtual void OnUpdate(const float deltaTime) override;
	virtual void OnRender(void) const override;
	virtual void OnOpen(void) override;
	virtual void OnClose(void) override;

private:
	tbGraphics::FullScreenQuad mWinBackdrop;
	tbGraphics::FullScreenQuad mLoseBackdrop;
	tbGraphics::Text mResultsText;

	tbGame::GameTimer mFadeInTimer;
	tbGame::GameTimer mFadeOutTimer;
	tbGame::InputAction mBackToTitleAction;

	struct ScoringResult
	{
		tbGraphics::Text mDescriptionText;
		tbGraphics::Text mScoreText;
		tbGraphics::Text mBestScoreText;
		int mCurrentValue;
		int mScoreValue;
		int mBestValue;
	};

	std::vector<ScoringResult*> mResultingScores;
};

#endif /* _LudumDare37_TitleScene_h_ */
