///
/// @file
/// @details An entity within the LudumDare37 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#include "score_display.h"
#include "game_results.h"

//--------------------------------------------------------------------------------------------------------------------//

ScoreDisplay::ScoreDisplay(void) :
	tbGame::Entity("ScoreDisplay")
{
	mScoreText.SetScroll(0.0f);
	AddGraphic(mScoreText);

	mBestScoreText.SetScroll(0.0f);
	AddGraphic(mBestScoreText);
}

//--------------------------------------------------------------------------------------------------------------------//

ScoreDisplay::~ScoreDisplay(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void ScoreDisplay::OnAdded(void)
{
	tbGame::Entity::OnAdded();
}

//--------------------------------------------------------------------------------------------------------------------//

void ScoreDisplay::OnRemoved(void)
{
	tbGame::Entity::OnRemoved();
}

//--------------------------------------------------------------------------------------------------------------------//

void ScoreDisplay::OnSimulate(void)
{
	tbGame::Entity::OnSimulate();
}

//--------------------------------------------------------------------------------------------------------------------//

void ScoreDisplay::OnUpdate(const float deltaTime)
{
	tbGame::Entity::OnUpdate(deltaTime);

	mScoreText.SetText("Score: " + tbCore::ToString(GameResults::GetCurrentScore()));
	mScoreText.SetPosition(20.0f, 20.0f);

	mBestScoreText.SetText("Best: " + tbCore::ToString(GameResults::GetBestScore()));
	mBestScoreText.SetPosition(tbGraphics::ScreenWidth() - (20.0f + mBestScoreText.GetWidth()), 20.0f);
}

//--------------------------------------------------------------------------------------------------------------------//

void ScoreDisplay::OnRender(void) const
{
	tbGame::Entity::OnRender();
}

//--------------------------------------------------------------------------------------------------------------------//

void ScoreDisplay::OnCollideWith(tbGame::Entity& otherEntity)
{
	tbGame::Entity::OnCollideWith(otherEntity);
}

//--------------------------------------------------------------------------------------------------------------------//
