///
/// @file
/// @details An entity within the LudumDare37 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare37_ScoreDisplay_h_
#define _LudumDare37_ScoreDisplay_h_

#include "ludumdare37.h"

class ScoreDisplay : public tbGame::Entity
{
public:
	ScoreDisplay(void);
	virtual ~ScoreDisplay(void);

protected:
	virtual void OnAdded(void) override;
	virtual void OnRemoved(void) override;
	virtual void OnSimulate(void) override;
	virtual void OnUpdate(const float deltaTime) override;
	virtual void OnRender(void) const override;
	virtual void OnCollideWith(tbGame::Entity& otherEntity) override;

private:
	tbGraphics::Text mScoreText;
	tbGraphics::Text mBestScoreText;
};

#endif /* _LudumDare37_ScoreDisplay_h_ */
