///
/// @file
/// @details An entity within the LudumDare37 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#include "spellbook_button_entity.h"
#include "spellbook_entity.h"

//--------------------------------------------------------------------------------------------------------------------//

SpellbookButtonEntity::SpellbookButtonEntity(SpellbookEntity& spellbook, const SpellSchool& spellSchool) :
	ButtonEntity(),
	mSpellbook(spellbook),
	mSpellSchool(spellSchool),
	mPreppedSprite("spellbook_sheet", "prepped_spell_button"),
	mUsesText(tb_string("0")),
	mPositionOffset(),
	mUsesAvailable(0),
	mIsPreppedSpell(false)
{
	mPreppedSprite.PlayAnimation("prepped_spell", true);
	mPreppedSprite.SetOrigin(tbGraphics::kAnchorCenter);
	mPreppedSprite.SetVisible(false);

	SetOrigin(tbGraphics::kAnchorCenter);

	const tbMath::Vector2 spellbookOffsetPosition(0.0f, 75.0f);
	switch (spellSchool)
	{
	case SpellSchool::kFire:
		SetButtonSprites(tbGraphics::Sprite("spellbook_sheet", "fire_button"),
			tbGraphics::Sprite("spellbook_sheet", "fire_button_hover"), tbGraphics::Sprite("spellbook_sheet", "fire_button_disabled"));
		mPositionOffset = spellbookOffsetPosition + tbMath::Vector2(-112.0f, 24.0f);
		break;
	case SpellSchool::kWater:
		SetButtonSprites(tbGraphics::Sprite("spellbook_sheet", "water_button"),
			tbGraphics::Sprite("spellbook_sheet", "water_button_hover"), tbGraphics::Sprite("spellbook_sheet", "water_button_disabled"));
		mPositionOffset = spellbookOffsetPosition + tbMath::Vector2(-112.0f, 120.0f);
		break;
	case SpellSchool::kEarth:
		SetButtonSprites(tbGraphics::Sprite("spellbook_sheet", "earth_button"),
			tbGraphics::Sprite("spellbook_sheet", "earth_button_hover"), tbGraphics::Sprite("spellbook_sheet", "earth_button_disabled"));
		mPositionOffset = spellbookOffsetPosition + tbMath::Vector2(112.0f, 24.0f);
		break;
	case SpellSchool::kMind:
		SetButtonSprites(tbGraphics::Sprite("spellbook_sheet", "mind_button"),
			tbGraphics::Sprite("spellbook_sheet", "mind_button_hover"), tbGraphics::Sprite("spellbook_sheet", "mind_button_disabled"));
		mPositionOffset = spellbookOffsetPosition + tbMath::Vector2(112.0f, 120.0f);
		break;
	};

	AddGraphic(mPreppedSprite);
	AddGraphic(mUsesText);
	mUsesText.SetColor(tbGraphics::Color::kBlack);
	SetUsesAvailable(0);
}

//--------------------------------------------------------------------------------------------------------------------//

SpellbookButtonEntity::~SpellbookButtonEntity(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void SpellbookButtonEntity::SetUsesAvailable(const int usesAvailable)
{
	mUsesAvailable = usesAvailable;
	//mUsesText.SetText(SpellSchoolToString(mSpellSchool) + "  " + tb_string(mUsesAvailable));
	mUsesText.SetText("   x" + tb_string(mUsesAvailable));

	mUsesText.SetPosition(-tbMath::Vector2(mUsesText.GetWidth() / 2.0f, mUsesText.GetHeight() / 2.0f));

	if (mUsesAvailable <= 0)
	{
		SetButtonState(ButtonState::kDisabled);
		mUsesAvailable = 0;
	}
	else if (ButtonState::kDisabled == GetButtonState())
	{
		SetButtonState(ButtonState::kEnabled);
	}
}

//--------------------------------------------------------------------------------------------------------------------//

int SpellbookButtonEntity::GetUsesAvailable(void) const
{
	return mUsesAvailable;
}

//--------------------------------------------------------------------------------------------------------------------//

void SpellbookButtonEntity::SetAsPreppedSpell(bool isPrepped)
{
	mPreppedSprite.SetVisible(isPrepped);
}

//--------------------------------------------------------------------------------------------------------------------//

void SpellbookButtonEntity::SetCanBePrepped(bool canBePrepped)
{
	if (true == canBePrepped && mUsesAvailable > 0 && ButtonState::kDisabled == GetButtonState())
	{
		SetButtonState(ButtonState::kEnabled);
	}
	if (false == canBePrepped && ButtonState::kDisabled != GetButtonState())
	{
		SetButtonState(ButtonState::kDisabled);
	}
}

//--------------------------------------------------------------------------------------------------------------------//

void SpellbookButtonEntity::OnClicked(void)
{
	mSpellbook.PrepareSpellFromSchool(mSpellSchool);
}

//--------------------------------------------------------------------------------------------------------------------//

void SpellbookButtonEntity::OnUpdate(const float deltaTime)
{
	ButtonEntity::OnUpdate(deltaTime);

	SetPosition(mSpellbook.GetPosition() + mPositionOffset);
}

//--------------------------------------------------------------------------------------------------------------------//
