///
/// @file
/// @details An entity within the LudumDare37 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare37_SpellbookButtonEntity_h_
#define _LudumDare37_SpellbookButtonEntity_h_

#include "button_entity.h"

class SpellbookEntity;
enum class SpellSchool;

class SpellbookButtonEntity : public ButtonEntity
{
public:
	SpellbookButtonEntity(SpellbookEntity& spellbook, const SpellSchool& spellSchool);
	virtual ~SpellbookButtonEntity(void);

	void SetUsesAvailable(const int usesAvailable);
	int GetUsesAvailable(void) const;
	void SetAsPreppedSpell(bool isPrepped);

	void SetCanBePrepped(bool canBePrepped);

protected:
	virtual void OnClicked(void) override;

	virtual void OnUpdate(const float deltaTime) override;

private:
	SpellbookEntity& mSpellbook;
	const SpellSchool mSpellSchool;
	
	tbGraphics::AnimatedSprite mPreppedSprite;
	tbGraphics::Text mUsesText;
	tbMath::Vector2 mPositionOffset; //From Spellbook position.
	int mUsesAvailable;
	bool mIsPreppedSpell;
};

#endif /* _LudumDare37_SpellbookButtonEntity_h_ */
