///
/// @file
/// @details An entity within the LudumDare37 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare37_SpellbookEntity_h_
#define _LudumDare37_SpellbookEntity_h_

#include "ludumdare37.h"
#include "spellbook_button_entity.h"

#include <array>

enum class SpellSchool
{
	kFire,
	kWater,
	kEarth,
	kMind,
	kInvalid,
};

enum class Spell
{
	kFireBall,
	kIceSpray,
	kStoneFall,
	kMindControl,
};

size_t SpellSchoolToIndex(const SpellSchool& spellSchool);
SpellSchool IndexToSpellSchool(const size_t& schoolIndex);
tbCore::tbString SpellSchoolToString(const SpellSchool& spellSchool);

class SpellbookEntity : public tbGame::Entity
{
public:
	static const size_t kMaximumSpellSchools = 4;

	SpellbookEntity(void);
	virtual ~SpellbookEntity(void);

	void ResetToEmptyBook(void);

	bool IsSpellPrepped(void) const;
	bool IsSpellBeingCasted(void) const;
	void CastPreppedSpell(void);
	void ClearPreppedSpell(const bool byUsing);
	void PrepareSpellFromSchool(const SpellSchool& spellSchool);
	const SpellSchool& GetPreppedSpellSchool(void) const { return mPreppedSpellSchool; }

	//Will discard prepared spell, if there is one, without losing the spell.
	void SetCanPrepareSpell(const bool canPrepareSpell);
	
	int NumberOfSpellsRemaining(void) const;
	void RegenerateSpellLists(void);

protected:
	virtual void OnAdded(void) override;
	virtual void OnRemoved(void) override;
	virtual void OnSimulate(void) override;
	virtual void OnUpdate(const float deltaTime) override;
	virtual void OnRender(void) const override;
	virtual void OnCollideWith(tbGame::Entity& otherEntity) override;

private:
	tbGraphics::Sprite mSpellbookSprite;

	std::array<SpellbookButtonEntity*, kMaximumSpellSchools> mSpellSchoolButtons;

	bool mCanPrepareSpell;
	bool mIsSpellPrepped;
	tbGame::GameTimer mSpellCastingTimer;
	SpellSchool mPreppedSpellSchool;
};

#endif /* _LudumDare37_SpellbookEntity_h_ */
