///
/// @file
/// @details An entity within the LudumDare37 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#include "stay_or_leave_prompt.h"
#include "gameplay_scene.h"

//--------------------------------------------------------------------------------------------------------------------//

const tbMath::Vector2 kOffscreenOffset(0.0f, 360.0f + 300.0f); //From center of screen.
const tbMath::Vector2 kOnscreenOffset(0.0f, 100.0f); //From center of screen.

//--------------------------------------------------------------------------------------------------------------------//

StayOrLeavePrompt::StayOrLeavePrompt(GameplayScene& gameplayScene) :
	tbGame::Entity("StayOrLeavePrompt"),
	mGameplayScene(gameplayScene),
	mPromptSprite("game_sheet", "prompt_window"),
	mHoursSpentText("42", 42.0f),
	mEnemyCountText("42", 42.0f),
	mStayLongerButton(gameplayScene, true),
	mLeaveRoomButton(gameplayScene, false),
	mIsOnscreen(false),
	mHoursInRoom(0),
	mEnemiesInRoom(0)
{
	SetPosition(tbGraphics::ScreenCenter() + kOffscreenOffset);

	mPromptSprite.SetOrigin(tbGraphics::kAnchorCenter);
	AddGraphic(mPromptSprite);

	mHoursSpentText.SetPosition(-100.0f, -50.0f - mHoursSpentText.GetHeight());
	AddGraphic(mHoursSpentText);

	mEnemyCountText.SetPosition(100.0f, -50.0f - mEnemyCountText.GetHeight());
	AddGraphic(mEnemyCountText);

	mStayLongerButton.SetPosition(-125.0f, 50.0f);
	AddGraphic(mStayLongerButton);

	mLeaveRoomButton.SetPosition(125.0f, 50.0f);
	AddGraphic(mLeaveRoomButton);

	SetDepth(1.0f);

	mStayLongerButton.SetButtonSprites(tbGraphics::Sprite("game_sheet", "stay_button"),
		tbGraphics::Sprite("game_sheet", "stay_button_hover"), tbGraphics::Sprite("game_sheet", "stay_button_disabled"));
	mLeaveRoomButton.SetButtonSprites(tbGraphics::Sprite("game_sheet", "leave_button"),
		tbGraphics::Sprite("game_sheet", "leave_button_hover"), tbGraphics::Sprite("game_sheet", "leave_button_disabled"));
}

//--------------------------------------------------------------------------------------------------------------------//

StayOrLeavePrompt::~StayOrLeavePrompt(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void StayOrLeavePrompt::ResetToInitial(void)
{
	mIsOnscreen = false;
	SetPosition(tbGraphics::ScreenCenter() + kOffscreenOffset);
	PopAllBehaviors();
	SetHoursInRoom(0);
	SetEnemiesInRoom(0);
}

//--------------------------------------------------------------------------------------------------------------------//

void StayOrLeavePrompt::ShowPrompt(void)
{
	if (false == mIsOnscreen)
	{
		mIsOnscreen = true;
		PopAllBehaviors();
		PushBehavior(new tbGame::MoveToBehavior(*this, tbGraphics::ScreenCenter() + kOnscreenOffset, 800.0f));
	}
}

//--------------------------------------------------------------------------------------------------------------------//

void StayOrLeavePrompt::HidePrompt(void)
{
	if (true == mIsOnscreen)
	{
		mIsOnscreen = false;
		PopAllBehaviors();
		PushBehavior(new tbGame::MoveToBehavior(*this, tbGraphics::ScreenCenter() + kOffscreenOffset, 800.0f));
	}
}

//--------------------------------------------------------------------------------------------------------------------//

bool StayOrLeavePrompt::IsPromptShowing(void) const
{
	return mIsOnscreen;
}

//--------------------------------------------------------------------------------------------------------------------//

void StayOrLeavePrompt::SetHoursInRoom(const int hoursInRoom)
{
	mHoursInRoom = hoursInRoom;
	mHoursSpentText.SetText(tb_string(mHoursInRoom));
	mHoursSpentText.SetPosition(-100.0f, -50.0f - mHoursSpentText.GetHeight());
}

//--------------------------------------------------------------------------------------------------------------------//

void StayOrLeavePrompt::SetEnemiesInRoom(const int enemiesInRoom)
{
	mEnemiesInRoom = enemiesInRoom;
	mEnemyCountText.SetText(tb_string(mEnemiesInRoom));
	mEnemyCountText.SetPosition(100.0f, -50.0f - mEnemyCountText.GetHeight());
}

//--------------------------------------------------------------------------------------------------------------------//

void StayOrLeavePrompt::OnAdded(void)
{
	tbGame::Entity::OnAdded();
}

//--------------------------------------------------------------------------------------------------------------------//

void StayOrLeavePrompt::OnRemoved(void)
{
	tbGame::Entity::OnRemoved();
}

//--------------------------------------------------------------------------------------------------------------------//

void StayOrLeavePrompt::OnSimulate(void)
{
	tbGame::Entity::OnSimulate();

	mStayLongerButton.SetInputOffset(GetPosition());
	mLeaveRoomButton.SetInputOffset(GetPosition());
}

//--------------------------------------------------------------------------------------------------------------------//

void StayOrLeavePrompt::OnUpdate(const float deltaTime)
{
	tbGame::Entity::OnUpdate(deltaTime);
}

//--------------------------------------------------------------------------------------------------------------------//

void StayOrLeavePrompt::OnRender(void) const
{
	tbGame::Entity::OnRender();
}

//--------------------------------------------------------------------------------------------------------------------//

void StayOrLeavePrompt::OnCollideWith(tbGame::Entity& otherEntity)
{
	tbGame::Entity::OnCollideWith(otherEntity);
}

//--------------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------------//

StayOrLeaveButton::StayOrLeaveButton(GameplayScene& gameplayScene, bool isStayButton) :
	mGameplayScene(gameplayScene),
	mIsStayButton(isStayButton)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void StayOrLeaveButton::OnClicked(void)
{
	if (true == mIsStayButton)
	{
		mGameplayScene.StayInRoomForAnotherHour();
	}
	else
	{
		mGameplayScene.LeaveRoomLikeAChicken();
	}
}

//--------------------------------------------------------------------------------------------------------------------//
