///
/// @file
/// @details An entity within the LudumDare37 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare37_StayOrLeavePrompt_h_
#define _LudumDare37_StayOrLeavePrompt_h_

#include "ludumdare37.h"
#include "button_entity.h"
class GameplayScene;


class StayOrLeaveButton : public ButtonEntity
{
public:
	StayOrLeaveButton(GameplayScene& gameplayScene, bool isStayButton);

protected:
	virtual void OnClicked(void) override;

private:
	GameplayScene& mGameplayScene;
	const bool mIsStayButton;
};

class StayOrLeavePrompt : public tbGame::Entity
{
public:
	StayOrLeavePrompt(GameplayScene& gameplayScene);
	virtual ~StayOrLeavePrompt(void);

	void ResetToInitial(void);
	void ShowPrompt(void);
	void HidePrompt(void);

	bool IsPromptShowing(void) const;

	void SetHoursInRoom(const int hoursInRoom);
	void SetEnemiesInRoom(const int enemiesInRoom);

protected:
	virtual void OnAdded(void) override;
	virtual void OnRemoved(void) override;
	virtual void OnSimulate(void) override;
	virtual void OnUpdate(const float deltaTime) override;
	virtual void OnRender(void) const override;
	virtual void OnCollideWith(tbGame::Entity& otherEntity) override;

private:
	GameplayScene& mGameplayScene;
	tbGraphics::Sprite mPromptSprite;
	tbGraphics::Text mHoursSpentText;
	tbGraphics::Text mEnemyCountText;
	StayOrLeaveButton mStayLongerButton;
	StayOrLeaveButton mLeaveRoomButton;
	bool mIsOnscreen;
	int mHoursInRoom;
	int mEnemiesInRoom;
};

#endif /* _LudumDare37_StayOrLeavePrompt_h_ */
