///
/// @file
/// @details Provide a simple title scene for the LudumDare37 project that will fade out into gameplay.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare37_TitleScene_h_
#define _LudumDare37_TitleScene_h_

#include "ludumdare37.h"

class TitleScene : public tbGame::GameScene
{
public:
	TitleScene(void);
	virtual ~TitleScene(void);

protected:
	virtual void OnSimulate(void) override;
	virtual void OnUpdate(const float deltaTime) override;
	virtual void OnRender(void) const override;
	virtual void OnOpen(void) override;
	virtual void OnClose(void) override;

private:
	tbGame::GameTimer mFadeInTimer;
	tbGame::GameTimer mFadeOutTimer;
	tbGame::InputAction mStartGameAction;
	tbGame::InputAction mQuitGameAction;
};

#endif /* _LudumDare37_TitleScene_h_ */
